/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.constants;

public class CommerceOrderConstants {
    public static final String COMMERCE_ORDER = "commerce-order";
    public static final int ORDER_STATUS_ANY = -1;
    public static final int ORDER_STATUS_AWAITING_FULFILLMENT = 11;
    public static final int ORDER_STATUS_AWAITING_PICKUP = 13;
    public static final int ORDER_STATUS_AWAITING_SHIPMENT = 12;
    public static final int ORDER_STATUS_CANCELLED = 8;
    public static final int ORDER_STATUS_COMPLETED = 0;
    public static final int ORDER_STATUS_DECLINED = 16;
    public static final int ORDER_STATUS_DISPUTED = 18;
    public static final int ORDER_STATUS_IN_PROGRESS = 6;
    public static final int ORDER_STATUS_OPEN = 2;
    public static final int ORDER_STATUS_PARTIALLY_REFUNDED = 19;
    public static final int ORDER_STATUS_PARTIALLY_SHIPPED = 14;
    public static final int ORDER_STATUS_REFUNDED = 17;
    public static final int ORDER_STATUS_SHIPPED = 15;
    public static final int ORDER_STATUS_SUBSCRIPTION = 9;
    public static final int ORDER_STATUS_TO_TRANSMIT = 1;
    public static final int ORDER_STATUS_TRANSMITTED = 10;
    public static final int[] ORDER_STATUSES = new int[]{-1, 0, 1, 2, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    public static final int PAYMENT_STATUS_AUTHORIZED = 2;
    public static final int PAYMENT_STATUS_PAID = 0;
    public static final int PAYMENT_STATUS_PENDING = 1;
    public static final int[] PAYMENT_STATUSES = new int[]{2, 0, 1};
    public static final String RESOURCE_NAME = "com.liferay.commerce.order";
    public static final long TYPE_PK_APPROVAL = 0L;
    public static final long TYPE_PK_TRANSMISSION = 1L;

    public static String getOrderStatusLabel(int orderStatus) {
        if (orderStatus == -1) {
            return "any";
        }
        if (orderStatus == 11) {
            return "awaiting-fulfillment";
        }
        if (orderStatus == 13) {
            return "awaiting-pickup";
        }
        if (orderStatus == 12) {
            return "awaiting-shipment";
        }
        if (orderStatus == 8) {
            return "cancelled";
        }
        if (orderStatus == 0) {
            return "completed";
        }
        if (orderStatus == 16) {
            return "declined";
        }
        if (orderStatus == 18) {
            return "disputed";
        }
        if (orderStatus == 6) {
            return "in-progress";
        }
        if (orderStatus == 2) {
            return "open";
        }
        if (orderStatus == 19) {
            return "partially-refunded";
        }
        if (orderStatus == 14) {
            return "partially-shipped";
        }
        if (orderStatus == 17) {
            return "refunded";
        }
        if (orderStatus == 15) {
            return "shipped";
        }
        if (orderStatus == 9) {
            return "subscription";
        }
        if (orderStatus == 1) {
            return "to-transmit";
        }
        if (orderStatus == 10) {
            return "transmitted";
        }
        return null;
    }

    public static String getPaymentStatusLabel(int paymentStatus) {
        if (paymentStatus == 2) {
            return "authorized";
        }
        if (paymentStatus == 0) {
            return "paid";
        }
        if (paymentStatus == 1) {
            return "pending";
        }
        return null;
    }
}

