/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CommerceWarehouseItem service. Represents a row in the &quot;CommerceWarehouseItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.model.impl.CommerceWarehouseItemModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.model.impl.CommerceWarehouseItemImpl</code>.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceWarehouseItem
 * @generated
 */
@ProviderType
public interface CommerceWarehouseItemModel
	extends BaseModel<CommerceWarehouseItem>, GroupedModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce warehouse item model instance should use the {@link CommerceWarehouseItem} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce warehouse item.
	 *
	 * @return the primary key of this commerce warehouse item
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce warehouse item.
	 *
	 * @param primaryKey the primary key of this commerce warehouse item
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the commerce warehouse item ID of this commerce warehouse item.
	 *
	 * @return the commerce warehouse item ID of this commerce warehouse item
	 */
	public long getCommerceWarehouseItemId();

	/**
	 * Sets the commerce warehouse item ID of this commerce warehouse item.
	 *
	 * @param commerceWarehouseItemId the commerce warehouse item ID of this commerce warehouse item
	 */
	public void setCommerceWarehouseItemId(long commerceWarehouseItemId);

	/**
	 * Returns the group ID of this commerce warehouse item.
	 *
	 * @return the group ID of this commerce warehouse item
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this commerce warehouse item.
	 *
	 * @param groupId the group ID of this commerce warehouse item
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this commerce warehouse item.
	 *
	 * @return the company ID of this commerce warehouse item
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce warehouse item.
	 *
	 * @param companyId the company ID of this commerce warehouse item
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce warehouse item.
	 *
	 * @return the user ID of this commerce warehouse item
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce warehouse item.
	 *
	 * @param userId the user ID of this commerce warehouse item
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce warehouse item.
	 *
	 * @return the user uuid of this commerce warehouse item
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce warehouse item.
	 *
	 * @param userUuid the user uuid of this commerce warehouse item
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce warehouse item.
	 *
	 * @return the user name of this commerce warehouse item
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce warehouse item.
	 *
	 * @param userName the user name of this commerce warehouse item
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce warehouse item.
	 *
	 * @return the create date of this commerce warehouse item
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce warehouse item.
	 *
	 * @param createDate the create date of this commerce warehouse item
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce warehouse item.
	 *
	 * @return the modified date of this commerce warehouse item
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce warehouse item.
	 *
	 * @param modifiedDate the modified date of this commerce warehouse item
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce warehouse ID of this commerce warehouse item.
	 *
	 * @return the commerce warehouse ID of this commerce warehouse item
	 */
	public long getCommerceWarehouseId();

	/**
	 * Sets the commerce warehouse ID of this commerce warehouse item.
	 *
	 * @param commerceWarehouseId the commerce warehouse ID of this commerce warehouse item
	 */
	public void setCommerceWarehouseId(long commerceWarehouseId);

	/**
	 * Returns the c product ID of this commerce warehouse item.
	 *
	 * @return the c product ID of this commerce warehouse item
	 */
	public long getCProductId();

	/**
	 * Sets the c product ID of this commerce warehouse item.
	 *
	 * @param CProductId the c product ID of this commerce warehouse item
	 */
	public void setCProductId(long CProductId);

	/**
	 * Returns the cp instance uuid of this commerce warehouse item.
	 *
	 * @return the cp instance uuid of this commerce warehouse item
	 */
	@AutoEscape
	public String getCPInstanceUuid();

	/**
	 * Sets the cp instance uuid of this commerce warehouse item.
	 *
	 * @param CPInstanceUuid the cp instance uuid of this commerce warehouse item
	 */
	public void setCPInstanceUuid(String CPInstanceUuid);

	/**
	 * Returns the quantity of this commerce warehouse item.
	 *
	 * @return the quantity of this commerce warehouse item
	 */
	public int getQuantity();

	/**
	 * Sets the quantity of this commerce warehouse item.
	 *
	 * @param quantity the quantity of this commerce warehouse item
	 */
	public void setQuantity(int quantity);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(CommerceWarehouseItem commerceWarehouseItem);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CommerceWarehouseItem> toCacheModel();

	@Override
	public CommerceWarehouseItem toEscapedModel();

	@Override
	public CommerceWarehouseItem toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();

}