/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.context;

import com.liferay.commerce.account.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.exception.NoSuchCurrencyException;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.currency.util.comparator.CommerceCurrencyPriorityComparator;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.util.AccountEntryAllowedTypesUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BaseCommerceContextHttp
implements CommerceContext {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceContextHttp.class);
    private String[] _accountEntryAllowedTypes;
    private CommerceAccount _commerceAccount;
    private long[] _commerceAccountGroupIds;
    private CommerceAccountGroupServiceConfiguration _commerceAccountGroupServiceConfiguration;
    private final CommerceAccountHelper _commerceAccountHelper;
    private final CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;
    private final CommerceChannelLocalService _commerceChannelLocalService;
    private CommerceCurrency _commerceCurrency;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private CommerceOrder _commerceOrder;
    private final CommerceOrderHttpHelper _commerceOrderHttpHelper;
    private final HttpServletRequest _httpServletRequest;
    private final Portal _portal;

    public BaseCommerceContextHttp(HttpServletRequest httpServletRequest, CommerceAccountHelper commerceAccountHelper, CommerceChannelAccountEntryRelLocalService commerceChannelAccountEntryRelLocalService, CommerceChannelLocalService commerceChannelLocalService, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceOrderHttpHelper commerceOrderHttpHelper, ConfigurationProvider configurationProvider, Portal portal) {
        this._httpServletRequest = httpServletRequest;
        this._commerceAccountHelper = commerceAccountHelper;
        this._commerceChannelAccountEntryRelLocalService = commerceChannelAccountEntryRelLocalService;
        this._commerceChannelLocalService = commerceChannelLocalService;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceOrderHttpHelper = commerceOrderHttpHelper;
        this._portal = portal;
        try {
            CommerceChannel commerceChannel = this._fetchCommerceChannel();
            if (commerceChannel != null) {
                this._commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceChannel.getGroupId(), "com.liferay.commerce.account"));
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    @Override
    public String[] getAccountEntryAllowedTypes() throws PortalException {
        if (this._accountEntryAllowedTypes != null) {
            return this._accountEntryAllowedTypes;
        }
        this._accountEntryAllowedTypes = AccountEntryAllowedTypesUtil.getAllowedTypes(this.getCommerceSiteType());
        return this._accountEntryAllowedTypes;
    }

    @Override
    public CommerceAccount getCommerceAccount() throws PortalException {
        CommerceChannel commerceChannel = this._fetchCommerceChannel();
        if (commerceChannel == null) {
            return this._commerceAccount;
        }
        this._commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(commerceChannel.getGroupId(), this._httpServletRequest);
        return this._commerceAccount;
    }

    @Override
    public long[] getCommerceAccountGroupIds() throws PortalException {
        if (this._commerceAccountGroupIds != null) {
            return (long[])this._commerceAccountGroupIds.clone();
        }
        CommerceAccount commerceAccount = this.getCommerceAccount();
        if (commerceAccount == null) {
            return new long[0];
        }
        this._commerceAccountGroupIds = this._commerceAccountHelper.getCommerceAccountGroupIds(commerceAccount.getCommerceAccountId());
        return (long[])this._commerceAccountGroupIds.clone();
    }

    @Override
    public long getCommerceChannelGroupId() throws PortalException {
        return this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(this._portal.getScopeGroupId(this._httpServletRequest));
    }

    @Override
    public long getCommerceChannelId() throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(this._httpServletRequest));
        if (commerceChannel == null) {
            return 0L;
        }
        return commerceChannel.getCommerceChannelId();
    }

    @Override
    public CommerceCurrency getCommerceCurrency() throws PortalException {
        CommerceCurrency commerceCurrency;
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel;
        CommerceAccount commerceAccount;
        if (this._commerceCurrency != null) {
            return this._commerceCurrency;
        }
        long commerceChannelId = 0L;
        CommerceChannel commerceChannel = this._fetchCommerceChannel();
        if (commerceChannel != null) {
            commerceChannelId = commerceChannel.getCommerceChannelId();
        }
        if ((commerceAccount = this.getCommerceAccount()) != null && (commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(commerceAccount.getCommerceAccountId(), commerceChannelId, 6)) != null && (commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commerceChannelAccountEntryRel.getClassPK())).isActive()) {
            this._commerceCurrency = commerceCurrency;
            return this._commerceCurrency;
        }
        this._commerceCurrency = commerceChannel == null ? this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(this._portal.getCompanyId(this._httpServletRequest)) : this._getCommerceCurrency(this._portal.getCompanyId(this._httpServletRequest), commerceChannel.getCommerceCurrencyCode());
        return this._commerceCurrency;
    }

    @Override
    public CommerceOrder getCommerceOrder() {
        try {
            this._commerceOrder = this._commerceOrderHttpHelper.getCurrentCommerceOrder(this._httpServletRequest);
            return this._commerceOrder;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    @Override
    public int getCommerceSiteType() {
        if (this._commerceAccountGroupServiceConfiguration == null) {
            return 0;
        }
        return this._commerceAccountGroupServiceConfiguration.commerceSiteType();
    }

    private CommerceChannel _fetchCommerceChannel() throws PortalException {
        return this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(this._httpServletRequest));
    }

    private CommerceCurrency _getCommerceCurrency(long companyId, String currencyCode) {
        CommerceCurrency commerceCurrency;
        block5: {
            commerceCurrency = null;
            try {
                commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(companyId, currencyCode);
            }
            catch (NoSuchCurrencyException noSuchCurrencyException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)noSuchCurrencyException);
            }
        }
        if (commerceCurrency != null && commerceCurrency.isActive()) {
            return commerceCurrency;
        }
        commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(companyId);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        List commerceCurrencies = this._commerceCurrencyLocalService.getCommerceCurrencies(companyId, true, -1, -1, (OrderByComparator)new CommerceCurrencyPriorityComparator(true));
        if (!commerceCurrencies.isEmpty()) {
            commerceCurrency = (CommerceCurrency)commerceCurrencies.get(0);
        }
        return commerceCurrency;
    }
}

