/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service;

import aQute.bnd.annotation.ProviderType;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

@ProviderType
public class CommerceOrderServiceUtil {
    private static ServiceTracker<CommerceOrderService, CommerceOrderService> _serviceTracker;

    public static CommerceOrder addCommerceOrder(long groupId, long userId, long commerceAccountId, long commerceCurrencyId) throws PortalException {
        return CommerceOrderServiceUtil.getService().addCommerceOrder(groupId, userId, commerceAccountId, commerceCurrencyId);
    }

    public static CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long commerceCurrencyId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        return CommerceOrderServiceUtil.getService().addCommerceOrder(groupId, commerceAccountId, commerceCurrencyId, shippingAddressId, purchaseOrderNumber);
    }

    public static CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        return CommerceOrderServiceUtil.getService().addCommerceOrder(groupId, commerceAccountId, shippingAddressId, purchaseOrderNumber);
    }

    public static CommerceOrder approveCommerceOrder(long commerceOrderId) throws PortalException {
        return CommerceOrderServiceUtil.getService().approveCommerceOrder(commerceOrderId);
    }

    public static CommerceOrder checkoutCommerceOrder(long commerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().checkoutCommerceOrder(commerceOrderId, commerceContext, serviceContext);
    }

    public static void deleteCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrderServiceUtil.getService().deleteCommerceOrder(commerceOrderId);
    }

    public static CommerceOrder executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        return CommerceOrderServiceUtil.getService().executeWorkflowTransition(commerceOrderId, workflowTaskId, transitionName, comment);
    }

    public static CommerceOrder fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        return CommerceOrderServiceUtil.getService().fetchByExternalReferenceCode(companyId, externalReferenceCode);
    }

    public static CommerceOrder fetchCommerceOrder(long commerceOrderId) throws PortalException {
        return CommerceOrderServiceUtil.getService().fetchCommerceOrder(commerceOrderId);
    }

    public static CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) throws PortalException {
        return CommerceOrderServiceUtil.getService().fetchCommerceOrder(commerceAccountId, groupId, orderStatus);
    }

    public static CommerceOrder fetchCommerceOrder(String uuid, long groupId) throws PortalException {
        return CommerceOrderServiceUtil.getService().fetchCommerceOrder(uuid, groupId);
    }

    public static int[] getAvailableOrderStatuses(long commerceOrderId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getAvailableOrderStatuses(commerceOrderId);
    }

    public static CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrder(commerceOrderId);
    }

    public static CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrderByUuidAndGroupId(uuid, groupId);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrders(groupId, start, end, orderByComparator);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrders(groupId, orderStatuses);
    }

    public static int getCommerceOrdersCount(long groupId) throws PortalException {
        return CommerceOrderServiceUtil.getService().getCommerceOrdersCount(groupId);
    }

    public static String getOSGiServiceIdentifier() {
        return CommerceOrderServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static List<CommerceOrder> getPendingCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPendingCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    public static int getPendingCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPendingCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    public static List<CommerceOrder> getPlacedCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPlacedCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    public static int getPlacedCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return CommerceOrderServiceUtil.getService().getPlacedCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    public static void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderServiceUtil.getService().mergeGuestCommerceOrder(guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    public static CommerceOrder reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().reorderCommerceOrder(commerceOrderId, commerceContext);
    }

    public static CommerceOrder submitCommerceOrder(long commerceOrderId) throws PortalException {
        return CommerceOrderServiceUtil.getService().submitCommerceOrder(commerceOrderId);
    }

    public static CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateBillingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    public static CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, commerceContext);
    }

    public static CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, externalReferenceCode, commerceContext);
    }

    public static CommerceOrder updateOrderStatus(long commerceOrderId, int orderStatus) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateOrderStatus(commerceOrderId, orderStatus);
    }

    public static CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus) throws PortalException {
        return CommerceOrderServiceUtil.getService().updatePaymentStatus(commerceOrderId, paymentStatus);
    }

    public static CommerceOrder updatePaymentStatusAndTransactionId(long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        return CommerceOrderServiceUtil.getService().updatePaymentStatusAndTransactionId(commerceOrderId, paymentStatus, transactionId);
    }

    public static CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        return CommerceOrderServiceUtil.getService().updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    public static CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateShippingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    public static CommerceOrder updateTransactionId(long commerceOrderId, String transactionId) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateTransactionId(commerceOrderId, transactionId);
    }

    public static CommerceOrder updateUser(long commerceOrderId, long userId) throws PortalException {
        return CommerceOrderServiceUtil.getService().updateUser(commerceOrderId, userId);
    }

    public static CommerceOrderService getService() {
        return (CommerceOrderService)_serviceTracker.getService();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(CommerceOrderService.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), CommerceOrderService.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

