/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;

public class CommerceOrderServiceWrapper
implements CommerceOrderService,
ServiceWrapper<CommerceOrderService> {
    private CommerceOrderService _commerceOrderService;

    public CommerceOrderServiceWrapper() {
        this(null);
    }

    public CommerceOrderServiceWrapper(CommerceOrderService commerceOrderService) {
        this._commerceOrderService = commerceOrderService;
    }

    @Override
    public CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId) throws PortalException {
        return this._commerceOrderService.addCommerceOrder(groupId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId);
    }

    @Override
    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal subtotalWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal totalWithTaxAmount, int paymentStatus, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, int orderStatus, String advanceStatus, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.addOrUpdateCommerceOrder(externalReferenceCode, groupId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, taxAmount, total, subtotalWithTaxAmount, shippingWithTaxAmount, totalWithTaxAmount, paymentStatus, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, orderStatus, advanceStatus, commerceContext, serviceContext);
    }

    @Override
    public CommerceOrder addOrUpdateCommerceOrder(String externalReferenceCode, long groupId, long commerceAccountId, long commerceCurrencyId, long commerceOrderTypeId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal subtotalWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal totalWithTaxAmount, int paymentStatus, int orderStatus, String advanceStatus, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.addOrUpdateCommerceOrder(externalReferenceCode, groupId, commerceAccountId, commerceCurrencyId, commerceOrderTypeId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, taxAmount, total, subtotalWithTaxAmount, shippingWithTaxAmount, totalWithTaxAmount, paymentStatus, orderStatus, advanceStatus, commerceContext, serviceContext);
    }

    @Override
    public CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.applyCouponCode(commerceOrderId, couponCode, commerceContext);
    }

    @Override
    public void deleteCommerceOrder(long commerceOrderId) throws PortalException {
        this._commerceOrderService.deleteCommerceOrder(commerceOrderId);
    }

    @Override
    public CommerceOrder executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        return this._commerceOrderService.executeWorkflowTransition(commerceOrderId, workflowTaskId, transitionName, comment);
    }

    @Override
    public CommerceOrder fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._commerceOrderService.fetchByExternalReferenceCode(externalReferenceCode, companyId);
    }

    @Override
    public CommerceOrder fetchCommerceOrder(long commerceOrderId) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(commerceOrderId);
    }

    @Override
    @Deprecated
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(commerceAccountId, groupId, orderStatus);
    }

    @Override
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, long userId, int orderStatus) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(commerceAccountId, groupId, userId, orderStatus);
    }

    @Override
    public CommerceOrder fetchCommerceOrder(String uuid, long groupId) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(uuid, groupId);
    }

    @Override
    public CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        return this._commerceOrderService.getCommerceOrder(commerceOrderId);
    }

    @Override
    public CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this._commerceOrderService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, start, end, orderByComparator);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, orderStatuses);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, orderStatuses, start, end);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, commerceAccountId, start, end, orderByComparator);
    }

    @Override
    public int getCommerceOrdersCount(long groupId) throws PortalException {
        return this._commerceOrderService.getCommerceOrdersCount(groupId);
    }

    @Override
    public int getCommerceOrdersCount(long groupId, long commerceAccountId) throws PortalException {
        return this._commerceOrderService.getCommerceOrdersCount(groupId, commerceAccountId);
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return this._commerceOrderService.getOSGiServiceIdentifier();
    }

    @Override
    public List<CommerceOrder> getPendingCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getPendingCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    @Override
    public long getPendingCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        return this._commerceOrderService.getPendingCommerceOrdersCount(companyId, groupId);
    }

    @Override
    public int getPendingCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return this._commerceOrderService.getPendingCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    @Override
    public List<CommerceOrder> getPlacedCommerceOrders(long companyId, long groupId, int start, int end) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrders(companyId, groupId, start, end);
    }

    @Override
    public List<CommerceOrder> getPlacedCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    @Override
    public long getPlacedCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrdersCount(companyId, groupId);
    }

    @Override
    public int getPlacedCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    @Override
    public List<CommerceOrder> getUserCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getUserCommerceOrders(companyId, groupId, keywords, start, end);
    }

    @Override
    public long getUserCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return this._commerceOrderService.getUserCommerceOrdersCount(companyId, groupId, keywords);
    }

    @Override
    public List<CommerceOrder> getUserPendingCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getUserPendingCommerceOrders(companyId, groupId, keywords, start, end);
    }

    @Override
    public long getUserPendingCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return this._commerceOrderService.getUserPendingCommerceOrdersCount(companyId, groupId, keywords);
    }

    @Override
    public List<CommerceOrder> getUserPlacedCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getUserPlacedCommerceOrders(companyId, groupId, keywords, start, end);
    }

    @Override
    public long getUserPlacedCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return this._commerceOrderService.getUserPlacedCommerceOrdersCount(companyId, groupId, keywords);
    }

    @Override
    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderService.mergeGuestCommerceOrder(guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    @Override
    public CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.recalculatePrice(commerceOrderId, commerceContext);
    }

    @Override
    public CommerceOrder reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.reorderCommerceOrder(commerceOrderId, commerceContext);
    }

    @Override
    public CommerceOrder resetTermsAndConditions(long commerceOrderId, boolean deliveryCommerceTermEntry, boolean paymentCommerceTermEntry) throws PortalException {
        return this._commerceOrderService.resetTermsAndConditions(commerceOrderId, deliveryCommerceTermEntry, paymentCommerceTermEntry);
    }

    @Override
    public CommerceOrder updateBillingAddress(long commerceOrderId, long billingAddressId) throws PortalException {
        return this._commerceOrderService.updateBillingAddress(commerceOrderId, billingAddressId);
    }

    @Override
    public CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateBillingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    @Override
    public CommerceOrder updateCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        return this._commerceOrderService.updateCommerceOrder(commerceOrder);
    }

    @Override
    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal taxAmount, BigDecimal total, BigDecimal subtotalWithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal totalWithTaxAmount, BigDecimal totalDiscountAmount, String advanceStatus, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, taxAmount, total, subtotalWithTaxAmount, shippingWithTaxAmount, totalWithTaxAmount, totalDiscountAmount, advanceStatus, commerceContext);
    }

    @Override
    public CommerceOrder updateCommerceOrder(String externalReferenceCode, long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.updateCommerceOrder(externalReferenceCode, commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, commerceContext);
    }

    @Override
    public CommerceOrder updateCommerceOrderExternalReferenceCode(String externalReferenceCode, long commerceOrderId) throws PortalException {
        return this._commerceOrderService.updateCommerceOrderExternalReferenceCode(externalReferenceCode, commerceOrderId);
    }

    @Override
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        return this._commerceOrderService.updateCommerceOrderPrices(commerceOrderId, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4);
    }

    @Override
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4, BigDecimal subtotalWithTaxAmount, BigDecimal subtotalDiscountWithTaxAmount, BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount, BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount, BigDecimal shippingWithTaxAmount, BigDecimal shippingDiscountWithTaxAmount, BigDecimal shippingDiscountPercentageLevel1WithTaxAmount, BigDecimal shippingDiscountPercentageLevel2WithTaxAmount, BigDecimal shippingDiscountPercentageLevel3WithTaxAmount, BigDecimal shippingDiscountPercentageLevel4WithTaxAmount, BigDecimal totalWithTaxAmount, BigDecimal totalDiscountWithTaxAmount, BigDecimal totalDiscountPercentageLevel1WithTaxAmount, BigDecimal totalDiscountPercentageLevel2WithTaxAmount, BigDecimal totalDiscountPercentageLevel3WithTaxAmount, BigDecimal totalDiscountPercentageLevel4WithTaxAmount) throws PortalException {
        return this._commerceOrderService.updateCommerceOrderPrices(commerceOrderId, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4, subtotalWithTaxAmount, subtotalDiscountWithTaxAmount, subtotalDiscountPercentageLevel1WithTaxAmount, subtotalDiscountPercentageLevel2WithTaxAmount, subtotalDiscountPercentageLevel3WithTaxAmount, subtotalDiscountPercentageLevel4WithTaxAmount, shippingWithTaxAmount, shippingDiscountWithTaxAmount, shippingDiscountPercentageLevel1WithTaxAmount, shippingDiscountPercentageLevel2WithTaxAmount, shippingDiscountPercentageLevel3WithTaxAmount, shippingDiscountPercentageLevel4WithTaxAmount, totalWithTaxAmount, totalDiscountWithTaxAmount, totalDiscountPercentageLevel1WithTaxAmount, totalDiscountPercentageLevel2WithTaxAmount, totalDiscountPercentageLevel3WithTaxAmount, totalDiscountPercentageLevel4WithTaxAmount);
    }

    @Override
    public CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        return this._commerceOrderService.updateCommercePaymentMethodKey(commerceOrderId, commercePaymentMethodKey);
    }

    @Override
    public CommerceOrder updateCommerceShippingMethod(long commerceOrderId, long commerceShippingMethodId, String commerceShippingOptionName, CommerceContext commerceContext, Locale locale) throws PortalException {
        return this._commerceOrderService.updateCommerceShippingMethod(commerceOrderId, commerceShippingMethodId, commerceShippingOptionName, commerceContext, locale);
    }

    @Override
    public CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateInfo(commerceOrderId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, serviceContext);
    }

    @Override
    public CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateOrderDate(commerceOrderId, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, serviceContext);
    }

    @Override
    @Deprecated
    public CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus) throws PortalException {
        return this._commerceOrderService.updatePaymentStatus(commerceOrderId, paymentStatus);
    }

    @Override
    @Deprecated
    public CommerceOrder updatePaymentStatusAndTransactionId(long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        return this._commerceOrderService.updatePaymentStatusAndTransactionId(commerceOrderId, paymentStatus, transactionId);
    }

    @Override
    public CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        return this._commerceOrderService.updatePrintedNote(commerceOrderId, printedNote);
    }

    @Override
    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        return this._commerceOrderService.updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    @Override
    public CommerceOrder updateShippingAddress(long commerceOrderId, long shippingAddressId) throws PortalException {
        return this._commerceOrderService.updateShippingAddress(commerceOrderId, shippingAddressId);
    }

    @Override
    public CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long regionId, long countryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateShippingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, regionId, countryId, phoneNumber, serviceContext);
    }

    @Override
    public CommerceOrder updateTermsAndConditions(long commerceOrderId, long deliveryCommerceTermEntryId, long paymentCommerceTermEntryId, String languageId) throws PortalException {
        return this._commerceOrderService.updateTermsAndConditions(commerceOrderId, deliveryCommerceTermEntryId, paymentCommerceTermEntryId, languageId);
    }

    public CommerceOrderService getWrappedService() {
        return this._commerceOrderService;
    }

    public void setWrappedService(CommerceOrderService commerceOrderService) {
        this._commerceOrderService = commerceOrderService;
    }
}

