/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the CommerceSubscriptionCycleEntry service. Represents a row in the &quot;CSubscriptionCycleEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.commerce.model.impl.CommerceSubscriptionCycleEntryModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.commerce.model.impl.CommerceSubscriptionCycleEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceSubscriptionCycleEntry
 * @see com.liferay.commerce.model.impl.CommerceSubscriptionCycleEntryImpl
 * @see com.liferay.commerce.model.impl.CommerceSubscriptionCycleEntryModelImpl
 * @generated
 */
@ProviderType
public interface CommerceSubscriptionCycleEntryModel extends BaseModel<CommerceSubscriptionCycleEntry>,
	GroupedModel, ShardedModel, StagedAuditedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce subscription cycle entry model instance should use the {@link CommerceSubscriptionCycleEntry} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce subscription cycle entry.
	 *
	 * @return the primary key of this commerce subscription cycle entry
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce subscription cycle entry.
	 *
	 * @param primaryKey the primary key of this commerce subscription cycle entry
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the uuid of this commerce subscription cycle entry.
	 *
	 * @return the uuid of this commerce subscription cycle entry
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this commerce subscription cycle entry.
	 *
	 * @param uuid the uuid of this commerce subscription cycle entry
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the commerce subscription cycle entry ID of this commerce subscription cycle entry.
	 *
	 * @return the commerce subscription cycle entry ID of this commerce subscription cycle entry
	 */
	public long getCommerceSubscriptionCycleEntryId();

	/**
	 * Sets the commerce subscription cycle entry ID of this commerce subscription cycle entry.
	 *
	 * @param commerceSubscriptionCycleEntryId the commerce subscription cycle entry ID of this commerce subscription cycle entry
	 */
	public void setCommerceSubscriptionCycleEntryId(
		long commerceSubscriptionCycleEntryId);

	/**
	 * Returns the group ID of this commerce subscription cycle entry.
	 *
	 * @return the group ID of this commerce subscription cycle entry
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this commerce subscription cycle entry.
	 *
	 * @param groupId the group ID of this commerce subscription cycle entry
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this commerce subscription cycle entry.
	 *
	 * @return the company ID of this commerce subscription cycle entry
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce subscription cycle entry.
	 *
	 * @param companyId the company ID of this commerce subscription cycle entry
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce subscription cycle entry.
	 *
	 * @return the user ID of this commerce subscription cycle entry
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce subscription cycle entry.
	 *
	 * @param userId the user ID of this commerce subscription cycle entry
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce subscription cycle entry.
	 *
	 * @return the user uuid of this commerce subscription cycle entry
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce subscription cycle entry.
	 *
	 * @param userUuid the user uuid of this commerce subscription cycle entry
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce subscription cycle entry.
	 *
	 * @return the user name of this commerce subscription cycle entry
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce subscription cycle entry.
	 *
	 * @param userName the user name of this commerce subscription cycle entry
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce subscription cycle entry.
	 *
	 * @return the create date of this commerce subscription cycle entry
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce subscription cycle entry.
	 *
	 * @param createDate the create date of this commerce subscription cycle entry
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce subscription cycle entry.
	 *
	 * @return the modified date of this commerce subscription cycle entry
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce subscription cycle entry.
	 *
	 * @param modifiedDate the modified date of this commerce subscription cycle entry
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the commerce subscription entry ID of this commerce subscription cycle entry.
	 *
	 * @return the commerce subscription entry ID of this commerce subscription cycle entry
	 */
	public long getCommerceSubscriptionEntryId();

	/**
	 * Sets the commerce subscription entry ID of this commerce subscription cycle entry.
	 *
	 * @param commerceSubscriptionEntryId the commerce subscription entry ID of this commerce subscription cycle entry
	 */
	public void setCommerceSubscriptionEntryId(long commerceSubscriptionEntryId);

	/**
	 * Returns the commerce order item ID of this commerce subscription cycle entry.
	 *
	 * @return the commerce order item ID of this commerce subscription cycle entry
	 */
	public long getCommerceOrderItemId();

	/**
	 * Sets the commerce order item ID of this commerce subscription cycle entry.
	 *
	 * @param commerceOrderItemId the commerce order item ID of this commerce subscription cycle entry
	 */
	public void setCommerceOrderItemId(long commerceOrderItemId);

	/**
	 * Returns the renew of this commerce subscription cycle entry.
	 *
	 * @return the renew of this commerce subscription cycle entry
	 */
	public boolean getRenew();

	/**
	 * Returns <code>true</code> if this commerce subscription cycle entry is renew.
	 *
	 * @return <code>true</code> if this commerce subscription cycle entry is renew; <code>false</code> otherwise
	 */
	public boolean isRenew();

	/**
	 * Sets whether this commerce subscription cycle entry is renew.
	 *
	 * @param renew the renew of this commerce subscription cycle entry
	 */
	public void setRenew(boolean renew);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(
		CommerceSubscriptionCycleEntry commerceSubscriptionCycleEntry);

	@Override
	public int hashCode();

	@Override
	public CacheModel<CommerceSubscriptionCycleEntry> toCacheModel();

	@Override
	public CommerceSubscriptionCycleEntry toEscapedModel();

	@Override
	public CommerceSubscriptionCycleEntry toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}