/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.context;

import com.liferay.commerce.account.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.account.service.CommerceAccountService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;

public class BaseCommerceContext
implements CommerceContext {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceContext.class);
    private CommerceAccount _commerceAccount;
    private long[] _commerceAccountGroupIds;
    private CommerceAccountGroupServiceConfiguration _commerceAccountGroupServiceConfiguration;
    private final CommerceAccountHelper _commerceAccountHelper;
    private final long _commerceAccountId;
    private final CommerceAccountLocalService _commerceAccountLocalService;
    private final CommerceAccountService _commerceAccountService;
    private final long _commerceChannelGroupId;
    private final CommerceChannelLocalService _commerceChannelLocalService;
    private CommerceCurrency _commerceCurrency;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private CommerceOrder _commerceOrder;
    private final CommerceOrderService _commerceOrderService;
    private final long _companyId;
    private final long _orderId;

    public BaseCommerceContext(long companyId, long commerceChannelGroupId, long orderId, long commerceAccountId, CommerceAccountHelper commerceAccountHelper, CommerceAccountLocalService commerceAccountLocalService, CommerceAccountService commerceAccountService, CommerceChannelLocalService commerceChannelLocalService, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceOrderService commerceOrderService, ConfigurationProvider configurationProvider) {
        this._companyId = companyId;
        this._commerceChannelGroupId = commerceChannelGroupId;
        this._orderId = orderId;
        this._commerceAccountId = commerceAccountId;
        this._commerceAccountHelper = commerceAccountHelper;
        this._commerceAccountLocalService = commerceAccountLocalService;
        this._commerceAccountService = commerceAccountService;
        this._commerceChannelLocalService = commerceChannelLocalService;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceOrderService = commerceOrderService;
        try {
            if (this.getCommerceChannelGroupId() > 0L) {
                this._commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(this._commerceChannelGroupId, "com.liferay.commerce.account"));
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }

    @Override
    public CommerceAccount getCommerceAccount() throws PortalException {
        if (this._commerceAccount != null) {
            return this._commerceAccount;
        }
        if (this._commerceAccountId == -1L) {
            return this._commerceAccountLocalService.getGuestCommerceAccount(this._companyId);
        }
        this._commerceAccount = this._commerceAccountService.getCommerceAccount(this._commerceAccountId);
        return this._commerceAccount;
    }

    @Override
    public long[] getCommerceAccountGroupIds() throws PortalException {
        if (this._commerceAccountGroupIds != null) {
            return (long[])this._commerceAccountGroupIds.clone();
        }
        CommerceAccount commerceAccount = this.getCommerceAccount();
        if (commerceAccount == null) {
            return new long[0];
        }
        this._commerceAccountGroupIds = this._commerceAccountHelper.getCommerceAccountGroupIds(commerceAccount.getCommerceAccountId());
        return (long[])this._commerceAccountGroupIds.clone();
    }

    @Override
    public long getCommerceChannelGroupId() throws PortalException {
        return this._commerceChannelGroupId;
    }

    @Override
    public long getCommerceChannelId() throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(this._commerceChannelGroupId);
        if (commerceChannel == null) {
            return 0L;
        }
        return commerceChannel.getCommerceChannelId();
    }

    @Override
    public CommerceCurrency getCommerceCurrency() throws PortalException {
        if (this._commerceCurrency != null) {
            return this._commerceCurrency;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(this._commerceChannelGroupId);
        this._commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(this._companyId, commerceChannel.getCommerceCurrencyCode());
        return this._commerceCurrency;
    }

    @Override
    public CommerceOrder getCommerceOrder() throws PortalException {
        this._commerceOrder = this._commerceOrderService.fetchCommerceOrder(this._orderId);
        return this._commerceOrder;
    }

    @Override
    public int getCommerceSiteType() {
        if (this._commerceAccountGroupServiceConfiguration == null) {
            return 0;
        }
        return this._commerceAccountGroupServiceConfiguration.commerceSiteType();
    }
}

