/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.util.comparator;

import com.liferay.commerce.model.CommerceRegion;
import com.liferay.portal.kernel.util.OrderByComparator;

/**
 * @author Alessio Antonio Rendina
 */
public class CommerceRegionPriorityComparator
	extends OrderByComparator<CommerceRegion> {

	public static final String ORDER_BY_ASC = "CommerceRegion.priority ASC";

	public static final String ORDER_BY_DESC = "CommerceRegion.priority DESC";

	public static final String[] ORDER_BY_FIELDS = {"priority"};

	public CommerceRegionPriorityComparator() {
		this(false);
	}

	public CommerceRegionPriorityComparator(boolean ascending) {
		_ascending = ascending;
	}

	@Override
	public int compare(
		CommerceRegion commerceRegion1, CommerceRegion commerceRegion2) {

		int value = Double.compare(
			commerceRegion1.getPriority(), commerceRegion2.getPriority());

		if (_ascending) {
			return value;
		}

		return Math.negateExact(value);
	}

	@Override
	public String getOrderBy() {
		if (_ascending) {
			return ORDER_BY_ASC;
		}

		return ORDER_BY_DESC;
	}

	@Override
	public String[] getOrderByFields() {
		return ORDER_BY_FIELDS;
	}

	@Override
	public boolean isAscending() {
		return _ascending;
	}

	private final boolean _ascending;

}