/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.CommerceShipmentService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class CommerceShipmentServiceUtil {
    private static ServiceTracker<CommerceShipmentService, CommerceShipmentService> _serviceTracker;

    public static CommerceShipment addCommerceShipment(long groupId, long commerceAccountId, long commerceAddressId, long commerceShippingMethodId, String commerceShippingOptionName, ServiceContext serviceContext) throws PortalException {
        return CommerceShipmentServiceUtil.getService().addCommerceShipment(groupId, commerceAccountId, commerceAddressId, commerceShippingMethodId, commerceShippingOptionName, serviceContext);
    }

    public static CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        return CommerceShipmentServiceUtil.getService().addCommerceShipment(commerceOrderId, serviceContext);
    }

    @Deprecated
    public static void deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipmentServiceUtil.getService().deleteCommerceShipment(commerceShipmentId);
    }

    public static void deleteCommerceShipment(long commerceShipmentId, boolean restoreStockQuantity) throws PortalException {
        CommerceShipmentServiceUtil.getService().deleteCommerceShipment(commerceShipmentId, restoreStockQuantity);
    }

    public static CommerceShipment getCommerceShipment(long commerceShipmentId) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipment(commerceShipmentId);
    }

    public static List<CommerceShipment> getCommerceShipments(long companyId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipments(companyId, status, start, end, orderByComparator);
    }

    public static List<CommerceShipment> getCommerceShipments(long companyId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipments(companyId, start, end, orderByComparator);
    }

    public static List<CommerceShipment> getCommerceShipments(long companyId, long commerceAddressId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipments(companyId, commerceAddressId, start, end, orderByComparator);
    }

    public static List<CommerceShipment> getCommerceShipments(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus, int start, int end) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipments(companyId, groupIds, commerceAccountIds, keywords, shipmentStatuses, excludeShipmentStatus, start, end);
    }

    public static List<CommerceShipment> getCommerceShipmentsByOrderId(long commerceOrderId, int start, int end) {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsByOrderId(commerceOrderId, start, end);
    }

    public static int getCommerceShipmentsCount(long companyId) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCount(companyId);
    }

    public static int getCommerceShipmentsCount(long companyId, int status) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCount(companyId, status);
    }

    public static int getCommerceShipmentsCount(long companyId, long commerceAddressId) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCount(companyId, commerceAddressId);
    }

    public static int getCommerceShipmentsCount(long companyId, long[] groupIds, long[] commerceAccountIds, String keywords, int[] shipmentStatuses, boolean excludeShipmentStatus) throws PortalException {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCount(companyId, groupIds, commerceAccountIds, keywords, shipmentStatuses, excludeShipmentStatus);
    }

    public static int getCommerceShipmentsCountByOrderId(long commerceOrderId) {
        return CommerceShipmentServiceUtil.getService().getCommerceShipmentsCountByOrderId(commerceOrderId);
    }

    public static String getOSGiServiceIdentifier() {
        return CommerceShipmentServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static CommerceShipment updateAddress(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateAddress(commerceShipmentId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber);
    }

    public static CommerceShipment updateCarrierDetails(long commerceShipmentId, String carrier, String trackingNumber) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateCarrierDetails(commerceShipmentId, carrier, trackingNumber);
    }

    public static CommerceShipment updateCommerceShipment(long commerceShipmentId, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateCommerceShipment(commerceShipmentId, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public static CommerceShipment updateCommerceShipment(long commerceShipmentId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateCommerceShipment(commerceShipmentId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public static CommerceShipment updateExpectedDate(long commerceShipmentId, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateExpectedDate(commerceShipmentId, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }

    public static CommerceShipment updateShippingDate(long commerceShipmentId, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateShippingDate(commerceShipmentId, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute);
    }

    public static CommerceShipment updateStatus(long commerceShipmentId, int status) throws PortalException {
        return CommerceShipmentServiceUtil.getService().updateStatus(commerceShipmentId, status);
    }

    public static CommerceShipmentService getService() {
        return (CommerceShipmentService)_serviceTracker.getService();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(CommerceShipmentService.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), CommerceShipmentService.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

