/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.exception.CommerceShippingEngineException;

import java.util.List;
import java.util.Locale;

/**
 * @author Andrea Di Giorgi
 */
@ProviderType
public interface CommerceShippingEngine {

	public String getCommerceShippingOptionLabel(String name, Locale locale);

	public List<CommerceShippingOption> getCommerceShippingOptions(
			CommerceContext commerceContext, CommerceOrder commerceOrder,
			Locale locale)
		throws CommerceShippingEngineException;

	public String getDescription(Locale locale);

	public String getName(Locale locale);

}