/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.constants;

public class CommerceOrderConstants {
    public static final String COMMERCE_ORDER = "commerce-order";
    public static final String ORDER_NOTIFICATION_AWAITING_SHIPMENT = "order-awaiting-shipment";
    public static final String ORDER_NOTIFICATION_COMPLETED = "order-completed";
    public static final String ORDER_NOTIFICATION_PARTIALLY_SHIPPED = "order-partially-shipped";
    public static final String ORDER_NOTIFICATION_PLACED = "order-placed";
    public static final String ORDER_NOTIFICATION_PROCESSING = "order-processing";
    public static final String ORDER_NOTIFICATION_SHIPPED = "order-shipped";
    public static final int ORDER_STATUS_ANY = -1;
    public static final int ORDER_STATUS_AWAITING_PICKUP = 13;
    public static final int ORDER_STATUS_CANCELLED = 8;
    public static final int ORDER_STATUS_COMPLETED = 0;
    public static final int ORDER_STATUS_DECLINED = 16;
    public static final int ORDER_STATUS_DISPUTED = 18;
    public static final int ORDER_STATUS_IN_PROGRESS = 6;
    public static final int ORDER_STATUS_ON_HOLD = 20;
    public static final int ORDER_STATUS_OPEN = 2;
    public static final int ORDER_STATUS_PARTIALLY_REFUNDED = 19;
    public static final int ORDER_STATUS_PARTIALLY_SHIPPED = 14;
    public static final int ORDER_STATUS_PENDING = 1;
    public static final int ORDER_STATUS_PROCESSING = 10;
    public static final int ORDER_STATUS_REFUNDED = 17;
    public static final int ORDER_STATUS_SHIPPED = 15;
    public static final int ORDER_STATUS_SUBSCRIPTION = 9;
    public static final int[] ORDER_STATUSES_COMPLETED = new int[]{0, 8, 16};
    public static final int[] ORDER_STATUSES_OPEN = new int[]{6, 2};
    public static final int[] ORDER_STATUSES_PENDING = new int[]{1, 20};
    public static final int[] ORDER_STATUSES_PROCESSING = new int[]{10, 14, 15};
    public static final int PAYMENT_STATUS_AUTHORIZED = 2;
    public static final int PAYMENT_STATUS_PAID = 0;
    public static final int PAYMENT_STATUS_PENDING = 1;
    public static final String RESOURCE_NAME = "com.liferay.commerce.order";
    public static final long TYPE_PK_APPROVAL = 0L;
    public static final long TYPE_PK_FULFILLMENT = 1L;

    public static String getNotificationKey(int orderStatus) {
        if (orderStatus == 1) {
            return ORDER_NOTIFICATION_PLACED;
        }
        if (orderStatus == 10) {
            return ORDER_NOTIFICATION_PROCESSING;
        }
        if (orderStatus == 10) {
            return ORDER_NOTIFICATION_AWAITING_SHIPMENT;
        }
        if (orderStatus == 14) {
            return ORDER_NOTIFICATION_PARTIALLY_SHIPPED;
        }
        if (orderStatus == 15) {
            return ORDER_NOTIFICATION_SHIPPED;
        }
        if (orderStatus == 0) {
            return ORDER_NOTIFICATION_COMPLETED;
        }
        return "";
    }

    public static String getOrderStatusLabel(int orderStatus) {
        if (orderStatus == -1) {
            return "any";
        }
        if (orderStatus == 13) {
            return "awaiting-pickup";
        }
        if (orderStatus == 20) {
            return "on-hold";
        }
        if (orderStatus == 8) {
            return "cancelled";
        }
        if (orderStatus == 0) {
            return "completed";
        }
        if (orderStatus == 16) {
            return "declined";
        }
        if (orderStatus == 18) {
            return "disputed";
        }
        if (orderStatus == 10) {
            return "processing";
        }
        if (orderStatus == 6) {
            return "in-progress";
        }
        if (orderStatus == 2) {
            return "open";
        }
        if (orderStatus == 19) {
            return "partially-refunded";
        }
        if (orderStatus == 14) {
            return "partially-shipped";
        }
        if (orderStatus == 17) {
            return "refunded";
        }
        if (orderStatus == 15) {
            return "shipped";
        }
        if (orderStatus == 9) {
            return "subscription";
        }
        if (orderStatus == 1) {
            return "pending";
        }
        return null;
    }

    public static String getOrderStatusLabelStyle(int orderStatus) {
        if (orderStatus == 8 || orderStatus == 16) {
            return "danger";
        }
        if (orderStatus == 0) {
            return "success";
        }
        if (orderStatus == 6 || orderStatus == 20 || orderStatus == 14 || orderStatus == 10 || orderStatus == 15) {
            return "warning";
        }
        return "info";
    }

    public static String getPaymentLabelStyle(int paymentStatus) {
        if (paymentStatus == 2) {
            return "info";
        }
        if (paymentStatus == 0) {
            return "success";
        }
        if (paymentStatus == 1) {
            return "warning";
        }
        return "";
    }

    public static String getPaymentStatusLabel(int paymentStatus) {
        if (paymentStatus == 2) {
            return "authorized";
        }
        if (paymentStatus == 0) {
            return "paid";
        }
        if (paymentStatus == 1) {
            return "pending";
        }
        return null;
    }

    public static String getStatusLabelStyle(int status) {
        if (status == 4) {
            return "danger";
        }
        if (status == 0) {
            return "success";
        }
        return "info";
    }
}

