/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class CommerceOrderLocalServiceUtil {
    private static ServiceTracker<CommerceOrderLocalService, CommerceOrderLocalService> _serviceTracker;

    public static CommerceOrder addCommerceOrder(CommerceOrder commerceOrder) {
        return CommerceOrderLocalServiceUtil.getService().addCommerceOrder(commerceOrder);
    }

    public static CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().addCommerceOrder(userId, groupId, commerceAccountId);
    }

    public static CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId);
    }

    public static CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, int paymentStatus, int orderStatus, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, paymentStatus, orderStatus, serviceContext);
    }

    public static CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, shippingAddressId, purchaseOrderNumber);
    }

    public static CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().addCommerceOrder(userId, groupId, commerceAccountId, shippingAddressId, purchaseOrderNumber);
    }

    public static CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().applyCouponCode(commerceOrderId, couponCode, commerceContext);
    }

    public static CommerceOrder createCommerceOrder(long commerceOrderId) {
        return CommerceOrderLocalServiceUtil.getService().createCommerceOrder(commerceOrderId);
    }

    public static CommerceOrder deleteCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().deleteCommerceOrder(commerceOrder);
    }

    public static CommerceOrder deleteCommerceOrder(long commerceOrderId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().deleteCommerceOrder(commerceOrderId);
    }

    public static void deleteCommerceOrders(long groupId) throws PortalException {
        CommerceOrderLocalServiceUtil.getService().deleteCommerceOrders(groupId);
    }

    public static void deleteCommerceOrders(long userId, Date date, int status) {
        CommerceOrderLocalServiceUtil.getService().deleteCommerceOrders(userId, date, status);
    }

    public static PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().deletePersistedModel(persistedModel);
    }

    public static DynamicQuery dynamicQuery() {
        return CommerceOrderLocalServiceUtil.getService().dynamicQuery();
    }

    public static <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return CommerceOrderLocalServiceUtil.getService().dynamicQuery(dynamicQuery);
    }

    public static <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return CommerceOrderLocalServiceUtil.getService().dynamicQuery(dynamicQuery, start, end);
    }

    public static <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return CommerceOrderLocalServiceUtil.getService().dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public static long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return CommerceOrderLocalServiceUtil.getService().dynamicQueryCount(dynamicQuery);
    }

    public static long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return CommerceOrderLocalServiceUtil.getService().dynamicQueryCount(dynamicQuery, projection);
    }

    public static CommerceOrder executeWorkflowTransition(long userId, long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().executeWorkflowTransition(userId, commerceOrderId, workflowTaskId, transitionName, comment);
    }

    public static CommerceOrder fetchByExternalReferenceCode(long companyId, String externalReferenceCode) {
        return CommerceOrderLocalServiceUtil.getService().fetchByExternalReferenceCode(companyId, externalReferenceCode);
    }

    public static CommerceOrder fetchCommerceOrder(long commerceOrderId) {
        return CommerceOrderLocalServiceUtil.getService().fetchCommerceOrder(commerceOrderId);
    }

    @Deprecated
    public static CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) {
        return CommerceOrderLocalServiceUtil.getService().fetchCommerceOrder(commerceAccountId, groupId, orderStatus);
    }

    public static CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, long userId, int orderStatus) {
        return CommerceOrderLocalServiceUtil.getService().fetchCommerceOrder(commerceAccountId, groupId, userId, orderStatus);
    }

    public static CommerceOrder fetchCommerceOrderByReferenceCode(long companyId, String externalReferenceCode) {
        return CommerceOrderLocalServiceUtil.getService().fetchCommerceOrderByReferenceCode(companyId, externalReferenceCode);
    }

    public static CommerceOrder fetchCommerceOrderByUuidAndGroupId(String uuid, long groupId) {
        return CommerceOrderLocalServiceUtil.getService().fetchCommerceOrderByUuidAndGroupId(uuid, groupId);
    }

    public static ActionableDynamicQuery getActionableDynamicQuery() {
        return CommerceOrderLocalServiceUtil.getService().getActionableDynamicQuery();
    }

    public static CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrder(commerceOrderId);
    }

    public static CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrderByUuidAndGroupId(uuid, groupId);
    }

    public static List<CommerceOrder> getCommerceOrders(int start, int end) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrders(start, end);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrders(groupId, start, end, orderByComparator);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrders(groupId, orderStatuses);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrders(groupId, orderStatuses, start, end);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrders(groupId, commerceAccountId, start, end, orderByComparator);
    }

    public static List<CommerceOrder> getCommerceOrders(long companyId, long groupId, long[] commerceAccountIds, String keywords, int[] orderStatuses, boolean excludeOrderStatus, int start, int end) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrders(companyId, groupId, commerceAccountIds, keywords, orderStatuses, excludeOrderStatus, start, end);
    }

    public static List<CommerceOrder> getCommerceOrders(long groupId, String commercePaymentMethodKey) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrders(groupId, commercePaymentMethodKey);
    }

    public static List<CommerceOrder> getCommerceOrdersByBillingAddress(long billingAddressId) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersByBillingAddress(billingAddressId);
    }

    public static List<CommerceOrder> getCommerceOrdersByCommerceAccountId(long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersByCommerceAccountId(commerceAccountId, start, end, orderByComparator);
    }

    public static List<CommerceOrder> getCommerceOrdersByShippingAddress(long shippingAddressId) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersByShippingAddress(shippingAddressId);
    }

    public static List<CommerceOrder> getCommerceOrdersByUuidAndCompanyId(String uuid, long companyId) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersByUuidAndCompanyId(uuid, companyId);
    }

    public static List<CommerceOrder> getCommerceOrdersByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersByUuidAndCompanyId(uuid, companyId, start, end, orderByComparator);
    }

    public static int getCommerceOrdersCount() {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersCount();
    }

    public static int getCommerceOrdersCount(long groupId) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersCount(groupId);
    }

    public static int getCommerceOrdersCount(long groupId, long commerceAccountId) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersCount(groupId, commerceAccountId);
    }

    public static long getCommerceOrdersCount(long companyId, long groupId, long[] commerceAccountIds, String keywords, int[] orderStatuses, boolean excludeOrderStatus) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersCount(companyId, groupId, commerceAccountIds, keywords, orderStatuses, excludeOrderStatus);
    }

    public static int getCommerceOrdersCountByCommerceAccountId(long commerceAccountId) {
        return CommerceOrderLocalServiceUtil.getService().getCommerceOrdersCountByCommerceAccountId(commerceAccountId);
    }

    public static ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return CommerceOrderLocalServiceUtil.getService().getExportActionableDynamicQuery(portletDataContext);
    }

    public static IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        return CommerceOrderLocalServiceUtil.getService().getIndexableActionableDynamicQuery();
    }

    public static String getOSGiServiceIdentifier() {
        return CommerceOrderLocalServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().getPersistedModel(primaryKeyObj);
    }

    @Deprecated
    public static List<CommerceOrder> getUserCommerceOrders(long groupId, long userId, long commerceAccountId, Integer orderStatus, boolean excludeOrderStatus, String keywords, int start, int end) {
        return CommerceOrderLocalServiceUtil.getService().getUserCommerceOrders(groupId, userId, commerceAccountId, orderStatus, excludeOrderStatus, keywords, start, end);
    }

    @Deprecated
    public static int getUserCommerceOrdersCount(long groupId, long userId, long commerceAccountId, Integer orderStatus, boolean excludeOrderStatus, String keywords) {
        return CommerceOrderLocalServiceUtil.getService().getUserCommerceOrdersCount(groupId, userId, commerceAccountId, orderStatus, excludeOrderStatus, keywords);
    }

    public static void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        CommerceOrderLocalServiceUtil.getService().mergeGuestCommerceOrder(guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    public static CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().recalculatePrice(commerceOrderId, commerceContext);
    }

    public static CommerceOrder reorderCommerceOrder(long userId, long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().reorderCommerceOrder(userId, commerceOrderId, commerceContext);
    }

    public static CommerceOrder resetCommerceOrderShipping(long commerceOrderId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().resetCommerceOrderShipping(commerceOrderId);
    }

    public static BaseModelSearchResult<CommerceOrder> searchCommerceOrders(SearchContext searchContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().searchCommerceOrders(searchContext);
    }

    public static long searchCommerceOrdersCount(SearchContext searchContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().searchCommerceOrdersCount(searchContext);
    }

    public static CommerceOrder updateAccount(long commerceOrderId, long userId, long commerceAccountId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateAccount(commerceOrderId, userId, commerceAccountId);
    }

    public static CommerceOrder updateBillingAddress(long commerceOrderId, long billingAddressId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateBillingAddress(commerceOrderId, billingAddressId);
    }

    public static CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateBillingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    public static CommerceOrder updateCommerceOrder(CommerceOrder commerceOrder) {
        return CommerceOrderLocalServiceUtil.getService().updateCommerceOrder(commerceOrder);
    }

    public static CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, commerceContext);
    }

    public static CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, externalReferenceCode, commerceContext);
    }

    public static CommerceOrder updateCommerceOrderExternalReferenceCode(long commerceOrderId, String externalReferenceCode) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateCommerceOrderExternalReferenceCode(commerceOrderId, externalReferenceCode);
    }

    public static CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateCommerceOrderPrices(commerceOrderId, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4);
    }

    public static CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateCommercePaymentMethodKey(commerceOrderId, commercePaymentMethodKey);
    }

    public static CommerceOrder updateCustomFields(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateCustomFields(commerceOrderId, serviceContext);
    }

    public static CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateInfo(commerceOrderId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, serviceContext);
    }

    public static CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateOrderDate(commerceOrderId, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, serviceContext);
    }

    public static CommerceOrder updateOrderStatus(long commerceOrderId, int orderStatus) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateOrderStatus(commerceOrderId, orderStatus);
    }

    public static CommerceOrder updatePaymentStatus(long userId, long commerceOrderId, int paymentStatus) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updatePaymentStatus(userId, commerceOrderId, paymentStatus);
    }

    public static CommerceOrder updatePaymentStatusAndTransactionId(long userId, long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updatePaymentStatusAndTransactionId(userId, commerceOrderId, paymentStatus, transactionId);
    }

    public static CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updatePrintedNote(commerceOrderId, printedNote);
    }

    public static CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    public static CommerceOrder updateShippingAddress(long commerceOrderId, long shippingAddressId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateShippingAddress(commerceOrderId, shippingAddressId);
    }

    public static CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateShippingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    public static CommerceOrder updateShippingMethod(long commerceOrderId, long commerceShippingMethodId, String shippingOptionName, BigDecimal shippingAmount, CommerceContext commerceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateShippingMethod(commerceOrderId, commerceShippingMethodId, shippingOptionName, shippingAmount, commerceContext);
    }

    public static CommerceOrder updateStatus(long userId, long commerceOrderId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateStatus(userId, commerceOrderId, status, serviceContext, workflowContext);
    }

    public static CommerceOrder updateTransactionId(long commerceOrderId, String transactionId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateTransactionId(commerceOrderId, transactionId);
    }

    public static CommerceOrder updateUser(long commerceOrderId, long userId) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().updateUser(commerceOrderId, userId);
    }

    public static CommerceOrder upsertCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, int paymentStatus, int orderStatus, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return CommerceOrderLocalServiceUtil.getService().upsertCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, paymentStatus, orderStatus, advanceStatus, externalReferenceCode, commerceContext, serviceContext);
    }

    public static CommerceOrderLocalService getService() {
        return (CommerceOrderLocalService)_serviceTracker.getService();
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(CommerceOrderLocalService.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), CommerceOrderLocalService.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

