/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;
import java.util.List;

public class CommerceOrderServiceWrapper
implements CommerceOrderService,
ServiceWrapper<CommerceOrderService> {
    private CommerceOrderService _commerceOrderService;

    public CommerceOrderServiceWrapper(CommerceOrderService commerceOrderService) {
        this._commerceOrderService = commerceOrderService;
    }

    @Override
    public CommerceOrder addCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId) throws PortalException {
        return this._commerceOrderService.addCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId);
    }

    @Override
    public CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long commerceCurrencyId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        return this._commerceOrderService.addCommerceOrder(groupId, commerceAccountId, commerceCurrencyId, shippingAddressId, purchaseOrderNumber);
    }

    @Override
    public CommerceOrder addCommerceOrder(long groupId, long commerceAccountId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        return this._commerceOrderService.addCommerceOrder(groupId, commerceAccountId, shippingAddressId, purchaseOrderNumber);
    }

    @Override
    public CommerceOrder applyCouponCode(long commerceOrderId, String couponCode, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.applyCouponCode(commerceOrderId, couponCode, commerceContext);
    }

    @Override
    public CommerceOrder approveCommerceOrder(long commerceOrderId) throws PortalException {
        return this._commerceOrderService.approveCommerceOrder(commerceOrderId);
    }

    @Override
    public CommerceOrder checkoutCommerceOrder(long commerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.checkoutCommerceOrder(commerceOrderId, commerceContext, serviceContext);
    }

    @Override
    public void deleteCommerceOrder(long commerceOrderId) throws PortalException {
        this._commerceOrderService.deleteCommerceOrder(commerceOrderId);
    }

    @Override
    public CommerceOrder executeWorkflowTransition(long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        return this._commerceOrderService.executeWorkflowTransition(commerceOrderId, workflowTaskId, transitionName, comment);
    }

    @Override
    public CommerceOrder fetchByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        return this._commerceOrderService.fetchByExternalReferenceCode(companyId, externalReferenceCode);
    }

    @Override
    public CommerceOrder fetchCommerceOrder(long commerceOrderId) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(commerceOrderId);
    }

    @Override
    public CommerceOrder fetchCommerceOrder(long commerceAccountId, long groupId, int orderStatus) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(commerceAccountId, groupId, orderStatus);
    }

    @Override
    public CommerceOrder fetchCommerceOrder(String uuid, long groupId) throws PortalException {
        return this._commerceOrderService.fetchCommerceOrder(uuid, groupId);
    }

    @Override
    public int[] getAvailableOrderStatuses(long commerceOrderId) throws PortalException {
        return this._commerceOrderService.getAvailableOrderStatuses(commerceOrderId);
    }

    @Override
    public CommerceOrder getCommerceOrder(long commerceOrderId) throws PortalException {
        return this._commerceOrderService.getCommerceOrder(commerceOrderId);
    }

    @Override
    public CommerceOrder getCommerceOrderByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this._commerceOrderService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, start, end, orderByComparator);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, orderStatuses);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, int[] orderStatuses, int start, int end) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, orderStatuses, start, end);
    }

    @Override
    public List<CommerceOrder> getCommerceOrders(long groupId, long commerceAccountId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) throws PortalException {
        return this._commerceOrderService.getCommerceOrders(groupId, commerceAccountId, start, end, orderByComparator);
    }

    @Override
    public int getCommerceOrdersCount(long groupId) throws PortalException {
        return this._commerceOrderService.getCommerceOrdersCount(groupId);
    }

    @Override
    public int getCommerceOrdersCount(long groupId, long commerceAccountId) throws PortalException {
        return this._commerceOrderService.getCommerceOrdersCount(groupId, commerceAccountId);
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return this._commerceOrderService.getOSGiServiceIdentifier();
    }

    @Override
    public List<CommerceOrder> getPendingCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getPendingCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    @Override
    public long getPendingCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        return this._commerceOrderService.getPendingCommerceOrdersCount(companyId, groupId);
    }

    @Override
    public int getPendingCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return this._commerceOrderService.getPendingCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    @Override
    public List<CommerceOrder> getPlacedCommerceOrders(long companyId, long groupId, int start, int end) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrders(companyId, groupId, start, end);
    }

    @Override
    public List<CommerceOrder> getPlacedCommerceOrders(long groupId, long commerceAccountId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrders(groupId, commerceAccountId, keywords, start, end);
    }

    @Override
    public long getPlacedCommerceOrdersCount(long companyId, long groupId) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrdersCount(companyId, groupId);
    }

    @Override
    public int getPlacedCommerceOrdersCount(long groupId, long commerceAccountId, String keywords) throws PortalException {
        return this._commerceOrderService.getPlacedCommerceOrdersCount(groupId, commerceAccountId, keywords);
    }

    @Override
    public List<CommerceOrder> getUserPendingCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getUserPendingCommerceOrders(companyId, groupId, keywords, start, end);
    }

    @Override
    public long getUserPendingCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return this._commerceOrderService.getUserPendingCommerceOrdersCount(companyId, groupId, keywords);
    }

    @Override
    public List<CommerceOrder> getUserPlacedCommerceOrders(long companyId, long groupId, String keywords, int start, int end) throws PortalException {
        return this._commerceOrderService.getUserPlacedCommerceOrders(companyId, groupId, keywords, start, end);
    }

    @Override
    public long getUserPlacedCommerceOrdersCount(long companyId, long groupId, String keywords) throws PortalException {
        return this._commerceOrderService.getUserPlacedCommerceOrdersCount(companyId, groupId, keywords);
    }

    @Override
    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        this._commerceOrderService.mergeGuestCommerceOrder(guestCommerceOrderId, userCommerceOrderId, commerceContext, serviceContext);
    }

    @Override
    public CommerceOrder reorderCommerceOrder(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.reorderCommerceOrder(commerceOrderId, commerceContext);
    }

    @Override
    public CommerceOrder submitCommerceOrder(long commerceOrderId) throws PortalException {
        return this._commerceOrderService.submitCommerceOrder(commerceOrderId);
    }

    @Override
    public CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateBillingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    @Override
    public CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, commerceContext);
    }

    @Override
    public CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext) throws PortalException {
        return this._commerceOrderService.updateCommerceOrder(commerceOrderId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, advanceStatus, externalReferenceCode, commerceContext);
    }

    @Override
    public CommerceOrder updateCommerceOrderExternalReferenceCode(long commerceOrderId, String externalReferenceCode) throws PortalException {
        return this._commerceOrderService.updateCommerceOrderExternalReferenceCode(commerceOrderId, externalReferenceCode);
    }

    @Override
    public CommerceOrder updateCommerceOrderPrices(long commerceOrderId, BigDecimal subtotal, BigDecimal subtotalDiscountAmount, BigDecimal subtotalDiscountPercentageLevel1, BigDecimal subtotalDiscountPercentageLevel2, BigDecimal subtotalDiscountPercentageLevel3, BigDecimal subtotalDiscountPercentageLevel4, BigDecimal shippingAmount, BigDecimal shippingDiscountAmount, BigDecimal shippingDiscountPercentageLevel1, BigDecimal shippingDiscountPercentageLevel2, BigDecimal shippingDiscountPercentageLevel3, BigDecimal shippingDiscountPercentageLevel4, BigDecimal taxAmount, BigDecimal total, BigDecimal totalDiscountAmount, BigDecimal totalDiscountPercentageLevel1, BigDecimal totalDiscountPercentageLevel2, BigDecimal totalDiscountPercentageLevel3, BigDecimal totalDiscountPercentageLevel4) throws PortalException {
        return this._commerceOrderService.updateCommerceOrderPrices(commerceOrderId, subtotal, subtotalDiscountAmount, subtotalDiscountPercentageLevel1, subtotalDiscountPercentageLevel2, subtotalDiscountPercentageLevel3, subtotalDiscountPercentageLevel4, shippingAmount, shippingDiscountAmount, shippingDiscountPercentageLevel1, shippingDiscountPercentageLevel2, shippingDiscountPercentageLevel3, shippingDiscountPercentageLevel4, taxAmount, total, totalDiscountAmount, totalDiscountPercentageLevel1, totalDiscountPercentageLevel2, totalDiscountPercentageLevel3, totalDiscountPercentageLevel4);
    }

    @Override
    public CommerceOrder updateCommercePaymentMethodKey(long commerceOrderId, String commercePaymentMethodKey) throws PortalException {
        return this._commerceOrderService.updateCommercePaymentMethodKey(commerceOrderId, commercePaymentMethodKey);
    }

    @Override
    public CommerceOrder updateCustomFields(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateCustomFields(commerceOrderId, serviceContext);
    }

    @Override
    public CommerceOrder updateInfo(long commerceOrderId, String printedNote, int requestedDeliveryDateMonth, int requestedDeliveryDateDay, int requestedDeliveryDateYear, int requestedDeliveryDateHour, int requestedDeliveryDateMinute, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateInfo(commerceOrderId, printedNote, requestedDeliveryDateMonth, requestedDeliveryDateDay, requestedDeliveryDateYear, requestedDeliveryDateHour, requestedDeliveryDateMinute, serviceContext);
    }

    @Override
    public CommerceOrder updateOrderDate(long commerceOrderId, int orderDateMonth, int orderDateDay, int orderDateYear, int orderDateHour, int orderDateMinute, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateOrderDate(commerceOrderId, orderDateMonth, orderDateDay, orderDateYear, orderDateHour, orderDateMinute, serviceContext);
    }

    @Override
    public CommerceOrder updateOrderStatus(long commerceOrderId, int orderStatus) throws PortalException {
        return this._commerceOrderService.updateOrderStatus(commerceOrderId, orderStatus);
    }

    @Override
    public CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus) throws PortalException {
        return this._commerceOrderService.updatePaymentStatus(commerceOrderId, paymentStatus);
    }

    @Override
    public CommerceOrder updatePaymentStatusAndTransactionId(long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        return this._commerceOrderService.updatePaymentStatusAndTransactionId(commerceOrderId, paymentStatus, transactionId);
    }

    @Override
    public CommerceOrder updatePrintedNote(long commerceOrderId, String printedNote) throws PortalException {
        return this._commerceOrderService.updatePrintedNote(commerceOrderId, printedNote);
    }

    @Override
    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        return this._commerceOrderService.updatePurchaseOrderNumber(commerceOrderId, purchaseOrderNumber);
    }

    @Override
    public CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.updateShippingAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, serviceContext);
    }

    @Override
    public CommerceOrder updateTransactionId(long commerceOrderId, String transactionId) throws PortalException {
        return this._commerceOrderService.updateTransactionId(commerceOrderId, transactionId);
    }

    @Override
    public CommerceOrder updateUser(long commerceOrderId, long userId) throws PortalException {
        return this._commerceOrderService.updateUser(commerceOrderId, userId);
    }

    @Override
    public CommerceOrder upsertCommerceOrder(long userId, long groupId, long commerceAccountId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, String commercePaymentMethodKey, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, int paymentStatus, int orderStatus, String advanceStatus, String externalReferenceCode, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        return this._commerceOrderService.upsertCommerceOrder(userId, groupId, commerceAccountId, commerceCurrencyId, billingAddressId, shippingAddressId, commercePaymentMethodKey, commerceShippingMethodId, shippingOptionName, purchaseOrderNumber, subtotal, shippingAmount, total, paymentStatus, orderStatus, advanceStatus, externalReferenceCode, commerceContext, serviceContext);
    }

    public CommerceOrderService getWrappedService() {
        return this._commerceOrderService;
    }

    public void setWrappedService(CommerceOrderService commerceOrderService) {
        this._commerceOrderService = commerceOrderService;
    }
}

