/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.util;

import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.portal.configuration.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;

public class CommerceChannelConfigurationUtil {
    private static final Log _log = LogFactoryUtil.getLog(CommerceChannelConfigurationUtil.class);

    public static String getOpenCommerceOrderVisibilityScope(long groupId) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin(permissionChecker.getCompanyId()) || permissionChecker.isGroupAdmin(groupId)) {
            return "";
        }
        try {
            CommerceOrderConfiguration commerceOrderConfiguration = (CommerceOrderConfiguration)ConfigurationProviderUtil.getConfiguration(CommerceOrderConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.order"));
            return commerceOrderConfiguration.openOrdersVisibilityScope();
        }
        catch (ConfigurationException configurationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)configurationException);
            }
            return "";
        }
    }

    public static String getPlacedCommerceOrderVisibilityScope(long groupId) {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin(permissionChecker.getCompanyId()) || permissionChecker.isGroupAdmin(groupId)) {
            return "";
        }
        try {
            CommerceOrderConfiguration commerceOrderConfiguration = (CommerceOrderConfiguration)ConfigurationProviderUtil.getConfiguration(CommerceOrderConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.order"));
            return commerceOrderConfiguration.placedOrdersVisibilityScope();
        }
        catch (ConfigurationException configurationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)configurationException);
            }
            return "";
        }
    }
}

