/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.constants;

import com.liferay.commerce.constants.CommerceOrderPaymentConstants;

public class CommercePaymentEntryConstants {
    public static final String RESOURCE_NAME = "com.liferay.commerce.payment";
    public static final int STATUS_AUTHORIZED = 2;
    public static final int STATUS_CANCELLED = 8;
    public static final int STATUS_COMPLETED = 0;
    public static final int STATUS_CREATED = 18;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_PENDING = 1;
    public static final int STATUS_REFUNDED = 17;
    public static final int[] STATUSES = new int[]{2, 8, 0, 18, 4, 1, 17};
    public static final int[] STATUSES_REFUND = new int[]{18, 4, 1, 17};
    public static final int TYPE_PAYMENT = 0;
    public static final int TYPE_REFUND = 1;
    public static final int[] TYPES = new int[]{0, 1};

    public static String getPaymentLabelStyle(int paymentStatus) {
        return CommerceOrderPaymentConstants.getOrderPaymentLabelStyle(paymentStatus);
    }

    public static String getPaymentStatusLabel(int paymentStatus) {
        if (paymentStatus == 18) {
            return "created";
        }
        if (paymentStatus == 17) {
            return "refunded";
        }
        return CommerceOrderPaymentConstants.getOrderPaymentStatusLabel(paymentStatus);
    }

    public static String getTypeLabel(int type) {
        if (type == 0) {
            return "payment";
        }
        if (type == 1) {
            return "refund";
        }
        return null;
    }
}

