/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.context;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.commerce.configuration.CommerceAccountGroupServiceConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.exception.NoSuchCurrencyException;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.currency.util.comparator.CommerceCurrencyPriorityComparator;
import com.liferay.commerce.helper.CommerceAccountHelper;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.product.discovery.CPConfigurationListDiscovery;
import com.liferay.commerce.product.model.CPConfigurationList;
import com.liferay.commerce.product.model.CPConfigurationListModel;
import com.liferay.commerce.product.model.CommerceCatalog;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.model.CommerceChannelAccountEntryRel;
import com.liferay.commerce.product.service.CommerceCatalogLocalService;
import com.liferay.commerce.product.service.CommerceChannelAccountEntryRelLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.util.AccountEntryAllowedTypesUtil;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.cookies.CookiesManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BaseCommerceContextHttp
implements CommerceContext {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommerceContextHttp.class);
    private AccountEntry _accountEntry;
    private String[] _accountEntryAllowedTypes;
    private final AccountGroupLocalService _accountGroupLocalService;
    private long[] _commerceAccountGroupIds;
    private CommerceAccountGroupServiceConfiguration _commerceAccountGroupServiceConfiguration;
    private final CommerceAccountHelper _commerceAccountHelper;
    private final CommerceCatalogLocalService _commerceCatalogLocalService;
    private final CommerceChannelAccountEntryRelLocalService _commerceChannelAccountEntryRelLocalService;
    private final CommerceChannelLocalService _commerceChannelLocalService;
    private CommerceCurrency _commerceCurrency;
    private final CommerceCurrencyLocalService _commerceCurrencyLocalService;
    private CommerceOrder _commerceOrder;
    private final CommerceOrderHttpHelper _commerceOrderHttpHelper;
    private final CPConfigurationListDiscovery _cpConfigurationListDiscovery;
    private Map<Long, CPConfigurationList> _cpConfigurationLists;
    private final HttpServletRequest _httpServletRequest;
    private final Portal _portal;

    public BaseCommerceContextHttp(HttpServletRequest httpServletRequest, AccountGroupLocalService accountGroupLocalService, CommerceAccountHelper commerceAccountHelper, CommerceCatalogLocalService commerceCatalogLocalService, CommerceChannelAccountEntryRelLocalService commerceChannelAccountEntryRelLocalService, CommerceChannelLocalService commerceChannelLocalService, CommerceCurrencyLocalService commerceCurrencyLocalService, CommerceOrderHttpHelper commerceOrderHttpHelper, ConfigurationProvider configurationProvider, CPConfigurationListDiscovery cpConfigurationListDiscovery, Portal portal) {
        this._httpServletRequest = httpServletRequest;
        this._accountGroupLocalService = accountGroupLocalService;
        this._commerceAccountHelper = commerceAccountHelper;
        this._commerceCatalogLocalService = commerceCatalogLocalService;
        this._commerceChannelAccountEntryRelLocalService = commerceChannelAccountEntryRelLocalService;
        this._commerceChannelLocalService = commerceChannelLocalService;
        this._commerceCurrencyLocalService = commerceCurrencyLocalService;
        this._commerceOrderHttpHelper = commerceOrderHttpHelper;
        this._cpConfigurationListDiscovery = cpConfigurationListDiscovery;
        this._portal = portal;
        try {
            CommerceChannel commerceChannel = this._fetchCommerceChannel();
            if (commerceChannel != null) {
                this._commerceAccountGroupServiceConfiguration = (CommerceAccountGroupServiceConfiguration)configurationProvider.getConfiguration(CommerceAccountGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(commerceChannel.getGroupId(), "com.liferay.commerce.account"));
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
    }

    @Override
    public AccountEntry getAccountEntry() throws PortalException {
        CommerceChannel commerceChannel = this._fetchCommerceChannel();
        if (commerceChannel == null && this._accountEntry != null) {
            return this._accountEntry;
        }
        this._accountEntry = this._commerceAccountHelper.getCurrentAccountEntry(commerceChannel.getGroupId(), this._httpServletRequest);
        return this._accountEntry;
    }

    @Override
    public String[] getAccountEntryAllowedTypes() throws PortalException {
        if (this._accountEntryAllowedTypes != null) {
            return this._accountEntryAllowedTypes;
        }
        this._accountEntryAllowedTypes = AccountEntryAllowedTypesUtil.getAllowedTypes(this.getCommerceSiteType());
        return this._accountEntryAllowedTypes;
    }

    @Override
    public long[] getCommerceAccountGroupIds() throws PortalException {
        if (this._commerceAccountGroupIds != null) {
            return (long[])this._commerceAccountGroupIds.clone();
        }
        AccountEntry accountEntry = this.getAccountEntry();
        if (accountEntry == null) {
            return new long[0];
        }
        this._commerceAccountGroupIds = this._accountGroupLocalService.getAccountGroupIds(accountEntry.getAccountEntryId());
        return (long[])this._commerceAccountGroupIds.clone();
    }

    @Override
    public long getCommerceChannelGroupId() throws PortalException {
        return this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(this._portal.getScopeGroupId(this._httpServletRequest));
    }

    @Override
    public long getCommerceChannelId() throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(this._httpServletRequest));
        if (commerceChannel == null) {
            return 0L;
        }
        return commerceChannel.getCommerceChannelId();
    }

    @Override
    public CommerceCurrency getCommerceCurrency() throws PortalException {
        CommerceCurrency commerceCurrency;
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel;
        AccountEntry accountEntry;
        if (this._commerceCurrency != null) {
            return this._commerceCurrency;
        }
        CommerceOrder commerceOrder = this.getCommerceOrder();
        if (commerceOrder != null) {
            return commerceOrder.getCommerceCurrency();
        }
        String commerceCurrencyCode = CookiesManagerUtil.getCookieValue((String)(CommerceCurrency.class.getName() + "#" + this.getCommerceChannelGroupId()), (HttpServletRequest)this._httpServletRequest);
        if (!Validator.isBlank((String)commerceCurrencyCode)) {
            this._commerceCurrency = this._commerceCurrencyLocalService.fetchCommerceCurrency(this._portal.getCompanyId(this._httpServletRequest), commerceCurrencyCode);
            if (this._commerceCurrency != null && this._commerceCurrency.isActive()) {
                return this._commerceCurrency;
            }
        }
        long commerceChannelId = 0L;
        CommerceChannel commerceChannel = this._fetchCommerceChannel();
        if (commerceChannel != null) {
            commerceChannelId = commerceChannel.getCommerceChannelId();
        }
        if ((accountEntry = this.getAccountEntry()) != null && (commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntry.getAccountEntryId(), commerceChannelId, 6)) != null && (commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(commerceChannelAccountEntryRel.getClassPK())).isActive()) {
            this._commerceCurrency = commerceCurrency;
            return this._commerceCurrency;
        }
        this._commerceCurrency = commerceChannel == null ? this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(this._portal.getCompanyId(this._httpServletRequest)) : this._getCommerceCurrency(this._portal.getCompanyId(this._httpServletRequest), commerceChannel.getCommerceCurrencyCode());
        return this._commerceCurrency;
    }

    @Override
    public CommerceOrder getCommerceOrder() {
        try {
            CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(this._httpServletRequest));
            if (commerceChannel == null) {
                return null;
            }
            this._commerceOrder = this._commerceOrderHttpHelper.getCurrentCommerceOrder(this._httpServletRequest);
            if (this._commerceOrder != null) {
                HttpServletRequest originalHttpServletRequest = this._portal.getOriginalServletRequest(this._httpServletRequest);
                long groupId = commerceChannel.getGroupId();
                HttpSession httpSession = originalHttpServletRequest.getSession();
                if (this._commerceOrder.isGuestOrder()) {
                    httpSession.removeAttribute(CommerceOrder.class.getName() + "#" + groupId);
                    return this._commerceOrder;
                }
                if (this._isChannelAccountEntry(this._commerceOrder.getCommerceAccountId(), this.getCommerceChannelId())) {
                    httpSession.setAttribute(CommerceOrder.class.getName() + "#" + groupId, (Object)this._commerceOrder.getUuid());
                } else {
                    httpSession.setAttribute(CommerceOrder.class.getName() + "#" + groupId, (Object)"");
                    this._commerceOrder = null;
                }
            }
            return this._commerceOrder;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    @Override
    public int getCommerceSiteType() {
        if (this._commerceAccountGroupServiceConfiguration == null) {
            return 0;
        }
        return this._commerceAccountGroupServiceConfiguration.commerceSiteType();
    }

    @Override
    public long getCPConfigurationListId(long groupId) throws PortalException {
        Map<Long, CPConfigurationList> cpConfigurationLists = this._getCPConfigurationLists();
        CPConfigurationList cpConfigurationList = cpConfigurationLists.get(groupId);
        return cpConfigurationList.getCPConfigurationListId();
    }

    @Override
    public long[] getCPConfigurationListIds() throws PortalException {
        Map<Long, CPConfigurationList> cpConfigurationLists = this._getCPConfigurationLists();
        return TransformUtil.transformToLongArray(cpConfigurationLists.values(), CPConfigurationListModel::getCPConfigurationListId);
    }

    private CommerceChannel _fetchCommerceChannel() throws PortalException {
        return this._commerceChannelLocalService.fetchCommerceChannelBySiteGroupId(this._portal.getScopeGroupId(this._httpServletRequest));
    }

    private CommerceCurrency _getCommerceCurrency(long companyId, String currencyCode) {
        CommerceCurrency commerceCurrency;
        block5: {
            commerceCurrency = null;
            try {
                commerceCurrency = this._commerceCurrencyLocalService.getCommerceCurrency(companyId, currencyCode);
            }
            catch (NoSuchCurrencyException noSuchCurrencyException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Throwable)noSuchCurrencyException);
            }
        }
        if (commerceCurrency != null && commerceCurrency.isActive()) {
            return commerceCurrency;
        }
        commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(companyId);
        if (commerceCurrency != null) {
            return commerceCurrency;
        }
        List commerceCurrencies = this._commerceCurrencyLocalService.getCommerceCurrencies(companyId, true, -1, -1, (OrderByComparator)CommerceCurrencyPriorityComparator.getInstance((boolean)true));
        if (!commerceCurrencies.isEmpty()) {
            commerceCurrency = (CommerceCurrency)commerceCurrencies.get(0);
        }
        return commerceCurrency;
    }

    private Map<Long, CPConfigurationList> _getCPConfigurationLists() throws PortalException {
        if (MapUtil.isNotEmpty(this._cpConfigurationLists)) {
            return this._cpConfigurationLists;
        }
        this._cpConfigurationLists = new HashMap<Long, CPConfigurationList>();
        long orderTypeId = 0L;
        CommerceOrder commerceOrder = this.getCommerceOrder();
        if (commerceOrder != null) {
            orderTypeId = commerceOrder.getCommerceOrderTypeId();
        }
        for (long groupId : TransformUtil.transformToLongArray((Collection)this._commerceCatalogLocalService.getCommerceCatalogs(this._portal.getCompanyId(this._httpServletRequest)), CommerceCatalog::getGroupId)) {
            this._cpConfigurationLists.put(groupId, this._cpConfigurationListDiscovery.getCPConfigurationList(this._portal.getCompanyId(this._httpServletRequest), groupId, CommerceUtil.getCommerceAccountId(this), this.getCommerceChannelId(), orderTypeId));
        }
        return this._cpConfigurationLists;
    }

    private boolean _isChannelAccountEntry(long accountEntryId, long commerceChannelId) {
        CommerceChannelAccountEntryRel commerceChannelAccountEntryRel = this._commerceChannelAccountEntryRelLocalService.fetchCommerceChannelAccountEntryRel(accountEntryId, commerceChannelId, 9);
        int count = this._commerceChannelAccountEntryRelLocalService.getCommerceChannelAccountEntryRelsCount(commerceChannelId, null, 9);
        return commerceChannelAccountEntryRel != null || count == 0;
    }
}

