/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.util.comparator;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.math.BigDecimal;

public class CommerceOrderTotalComparator
extends OrderByComparator<CommerceOrder> {
    public static final String ORDER_BY_ASC = "CommerceOrder.total ASC";
    public static final String ORDER_BY_DESC = "CommerceOrder.total DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"total"};
    private static final CommerceOrderTotalComparator _INSTANCE_ASCENDING = new CommerceOrderTotalComparator(true);
    private static final CommerceOrderTotalComparator _INSTANCE_DESCENDING = new CommerceOrderTotalComparator(false);
    private final boolean _ascending;

    public static CommerceOrderTotalComparator getInstance(boolean ascending) {
        if (ascending) {
            return _INSTANCE_ASCENDING;
        }
        return _INSTANCE_DESCENDING;
    }

    public int compare(CommerceOrder commerceOrder1, CommerceOrder commerceOrder2) {
        BigDecimal total1 = commerceOrder1.getTotal();
        int value = total1.compareTo(commerceOrder2.getTotal());
        if (this._ascending) {
            return value;
        }
        return Math.negateExact(value);
    }

    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    private CommerceOrderTotalComparator(boolean ascending) {
        this._ascending = ascending;
    }
}

