/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.item.selector.web.internal.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.util.PropsValues;
import jakarta.portlet.PortletResponse;
import jakarta.portlet.RenderResponse;

public class UserOrganizationChecker
extends EmptyOnClickRowChecker {
    private static final Log _log = LogFactoryUtil.getLog(UserOrganizationChecker.class);
    private final long _organizationId;

    public UserOrganizationChecker(RenderResponse renderResponse, long organizationId) {
        super((PortletResponse)renderResponse);
        this._organizationId = organizationId;
    }

    public boolean isChecked(Object object) {
        User user = (User)object;
        try {
            return UserLocalServiceUtil.hasOrganizationUser((long)this._organizationId, (long)user.getUserId());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return false;
        }
    }

    public boolean isDisabled(Object object) {
        if (this.isChecked(object)) {
            return true;
        }
        if (!PropsValues.ORGANIZATIONS_ASSIGNMENT_STRICT) {
            return false;
        }
        User user = (User)object;
        try {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (this.isChecked(user) ? OrganizationMembershipPolicyUtil.isMembershipProtected((PermissionChecker)permissionChecker, (long)user.getUserId(), (long)this._organizationId) || OrganizationMembershipPolicyUtil.isMembershipRequired((long)user.getUserId(), (long)this._organizationId) : !OrganizationMembershipPolicyUtil.isMembershipAllowed((long)user.getUserId(), (long)this._organizationId)) {
                return true;
            }
            return !UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)user.getUserId(), (String)"UPDATE");
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return super.isDisabled(object);
        }
    }
}

