/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.item.selector.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.users.admin.search.UserSearch;
import com.liferay.users.admin.search.UserSearchTerms;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class UserOAuth2ItemSelectorViewDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(UserOAuth2ItemSelectorViewDisplayContext.class);
    private final HttpServletRequest _httpServletRequest;
    private final PortletURL _portletURL;
    private final RenderRequest _renderRequest;
    private final ThemeDisplay _themeDisplay;
    private UserSearch _userSearch;

    public UserOAuth2ItemSelectorViewDisplayContext(HttpServletRequest httpServletRequest, PortletURL portletURL, RenderRequest renderRequest) {
        this._httpServletRequest = httpServletRequest;
        this._portletURL = portletURL;
        this._renderRequest = renderRequest;
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public SearchContainer<User> getUserSearchContainer() {
        if (this._userSearch != null) {
            return this._userSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UserSearch userSearch = new UserSearch((PortletRequest)this._renderRequest, this._portletURL);
        Group group = GroupLocalServiceUtil.fetchGroup((long)themeDisplay.getSiteGroupIdOrLiveGroupId());
        UserSearchTerms searchTerms = (UserSearchTerms)userSearch.getSearchTerms();
        LinkedHashMap userParams = LinkedHashMapBuilder.put((Object)"types", (Object)new long[]{2L, 1L, 3L}).build();
        if (group.isLimitedToParentSiteMembers()) {
            userParams.put("inherit", Boolean.TRUE);
            userParams.put("usersGroups", group.getParentGroupId());
        }
        List users = UserLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), (LinkedHashMap)userParams, (int)userSearch.getStart(), (int)userSearch.getEnd(), (OrderByComparator)userSearch.getOrderByComparator());
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this._themeDisplay.getUser());
        users.removeIf(user -> {
            try {
                return !UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)user.getUserId(), (long[])user.getOrganizationIds(), (String)"IMPERSONATE");
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)portalException);
                }
                return false;
            }
        });
        userSearch.setResultsAndTotal(() -> users, UserLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), (int)searchTerms.getStatus(), (LinkedHashMap)userParams));
        this._userSearch = userSearch;
        return this._userSearch;
    }
}

