/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.users.admin.item.selector.web.internal.search;

import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;

import javax.portlet.RenderResponse;

/**
 * @author Alessio Antonio Rendina
 */
public class UserItemSelectorChecker extends EmptyOnClickRowChecker {

	public UserItemSelectorChecker(
		RenderResponse renderResponse, long[] checkedUserIds,
		boolean checkedUserIdsEnabled) {

		super(renderResponse);

		_checkedUserIds = checkedUserIds;
		_checkedUserIdsEnabled = checkedUserIdsEnabled;
	}

	@Override
	public boolean isChecked(Object object) {
		User user = (User)object;

		return ArrayUtil.contains(_checkedUserIds, user.getUserId());
	}

	@Override
	public boolean isDisabled(Object object) {
		if (!_checkedUserIdsEnabled) {
			return isChecked(object);
		}

		return false;
	}

	private final long[] _checkedUserIds;
	private final boolean _checkedUserIdsEnabled;

}