/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={ModelPreFilterContributor.class})
public class UserModelPreFilterContributor
implements ModelPreFilterContributor {
    public void contribute(BooleanFilter contextBooleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        LinkedHashMap params;
        contextBooleanFilter.addTerm("defaultUser", Boolean.TRUE.toString(), BooleanClauseOccur.MUST_NOT);
        this._filterByEmailAddress(contextBooleanFilter, searchContext);
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextBooleanFilter.addRequiredTerm("status", status);
        }
        if ((params = (LinkedHashMap)searchContext.getAttribute("params")) == null) {
            return;
        }
        for (Map.Entry entry : params.entrySet()) {
            Object[] values;
            Class<?> clazz;
            Object value = entry.getValue();
            if (value == null || (clazz = value.getClass()).isArray() && value instanceof Object[] && (values = (Object[])value).length == 0) continue;
            this.addContextQueryParams(contextBooleanFilter, searchContext, (String)entry.getKey(), value);
        }
    }

    protected void addContextQueryParams(BooleanFilter contextFilter, SearchContext searchContext, String key, Object value) {
        if (key.equals("usersGroups")) {
            if (value instanceof Long[]) {
                Object[] values = (Long[])value;
                if (ArrayUtil.isEmpty((Object[])values)) {
                    return;
                }
                TermsFilter userGroupsTermsFilter = new TermsFilter("groupIds");
                userGroupsTermsFilter.addValues(ArrayUtil.toStringArray((Object[])values));
                contextFilter.add((Filter)userGroupsTermsFilter, BooleanClauseOccur.MUST);
            } else {
                contextFilter.addRequiredTerm("groupIds", String.valueOf(value));
            }
        } else if (key.equals("usersOrgs")) {
            if (value instanceof Long[]) {
                Object[] values = (Long[])value;
                if (ArrayUtil.isEmpty((Object[])values)) {
                    return;
                }
                String[] organizationIdsStrings = ArrayUtil.toStringArray((Object[])values);
                BooleanFilter userOrgsBooleanFilter = new BooleanFilter();
                userOrgsBooleanFilter.add((Filter)this._createTermsFilter("ancestorOrganizationIds", organizationIdsStrings));
                userOrgsBooleanFilter.add((Filter)this._createTermsFilter("organizationIds", organizationIdsStrings));
                contextFilter.add((Filter)userOrgsBooleanFilter, BooleanClauseOccur.MUST);
            } else {
                contextFilter.addRequiredTerm("organizationIds", String.valueOf(value));
            }
        } else if (key.equals("usersOrgsCount")) {
            contextFilter.addRequiredTerm("organizationCount", String.valueOf(value));
        } else if (key.equals("usersRoles")) {
            if (value instanceof Long[]) {
                Object[] values = (Long[])value;
                if (ArrayUtil.isEmpty((Object[])values)) {
                    return;
                }
                contextFilter.add((Filter)this._createTermsFilter("roleIds", ArrayUtil.toStringArray((Object[])values)), BooleanClauseOccur.MUST);
            } else {
                contextFilter.addRequiredTerm("roleIds", String.valueOf(value));
            }
        } else if (key.equals("usersTeams")) {
            contextFilter.addRequiredTerm("teamIds", String.valueOf(value));
        } else if (key.equals("usersUserGroups")) {
            contextFilter.addRequiredTerm("userGroupIds", String.valueOf(value));
        }
    }

    private TermsFilter _createTermsFilter(String filterName, String[] values) {
        TermsFilter termsFilter = new TermsFilter(filterName);
        termsFilter.addValues(values);
        return termsFilter;
    }

    private void _filterByEmailAddress(BooleanFilter booleanFilter, SearchContext searchContext) {
        String emailAddress = (String)((Object)searchContext.getAttribute("emailAddress"));
        if (Validator.isNull((String)emailAddress)) {
            return;
        }
        BooleanFilter emailAddressBooleanFilter = new BooleanFilter();
        emailAddressBooleanFilter.add((Filter)new QueryFilter((Query)new WildcardQueryImpl("emailAddress", emailAddress + "*")));
        emailAddressBooleanFilter.add((Filter)new QueryFilter((Query)new WildcardQueryImpl("emailAddressDomain", emailAddress + "*")));
        booleanFilter.add((Filter)emailAddressBooleanFilter, BooleanClauseOccur.MUST);
    }
}

