/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.xml.Element;
import jakarta.portlet.PortletPreferences;
import java.util.List;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"jakarta.portlet.name=com_liferay_users_admin_web_portlet_UsersAdminPortlet"}, service={PortletDataHandler.class})
public class UsersAdminPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "users_admin";
    public static final String SCHEMA_VERSION = "4.0.0";
    @Reference
    private OrganizationLocalService _organizationLocalService;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public boolean isSupportsDataStrategyCopyAsNew() {
        return false;
    }

    @Activate
    protected void activate() {
        this.setDataLevel(DataLevel.PORTAL);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(Organization.class)});
        this.setExportPortletDataHandlerControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "organizations", true, true, null, Organization.class.getName())});
    }

    protected PortletPreferences doDeleteData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        List organizations = this._organizationLocalService.getOrganizations(portletDataContext.getCompanyId(), -1L);
        for (Organization organization : organizations) {
            this._organizationLocalService.deleteOrganization(organization);
        }
        return portletPreferences;
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        portletDataContext.addPortalPermissions();
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        rootElement.addAttribute("group-id", String.valueOf(portletDataContext.getScopeGroupId()));
        ExportActionableDynamicQuery actionableDynamicQuery = this._organizationLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        portletDataContext.importPortalPermissions();
        Element organizationsElement = portletDataContext.getImportDataGroupElement(Organization.class);
        List organizationElements = organizationsElement.elements();
        for (Element organizationElement : organizationElements) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)organizationElement);
        }
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ExportActionableDynamicQuery actionableDynamicQuery = this._organizationLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.performCount();
    }
}

