/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.security.permission.wrapper;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.wrapper.PermissionCheckerWrapper;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class ServiceAccountUserPermissionCheckerWrapper
extends PermissionCheckerWrapper {
    private final PermissionChecker _permissionChecker;
    private final UserLocalService _userLocalService;

    public ServiceAccountUserPermissionCheckerWrapper(PermissionChecker permissionChecker, UserLocalService userLocalService) {
        super(permissionChecker);
        this._permissionChecker = permissionChecker;
        this._userLocalService = userLocalService;
    }

    public boolean hasPermission(Group group, String name, long primKey, String actionId) {
        if (!this._hasPermission(name, primKey)) {
            return false;
        }
        return this.permissionChecker.hasPermission(group, name, primKey, actionId);
    }

    public boolean hasPermission(Group group, String name, String primKey, String actionId) {
        if (!this._hasPermission(name, GetterUtil.getLong((String)primKey))) {
            return false;
        }
        return this.permissionChecker.hasPermission(group, name, primKey, actionId);
    }

    public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
        if (!this._hasPermission(name, primKey)) {
            return false;
        }
        return this.permissionChecker.hasPermission(groupId, name, primKey, actionId);
    }

    public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
        if (!this._hasPermission(name, GetterUtil.getLong((String)primKey))) {
            return false;
        }
        return this.permissionChecker.hasPermission(groupId, name, primKey, actionId);
    }

    private boolean _hasPermission(String name, long primKey) {
        User user;
        return !StringUtil.equals((String)name, (String)User.class.getName()) || (user = this._userLocalService.fetchUser(primKey)) == null || !user.isServiceAccountUser() || this._permissionChecker.isCompanyAdmin();
    }
}

