/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.generic.WildcardQueryImpl;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={KeywordQueryContributor.class})
public class UserKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    protected QueryHelper queryHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        this._addHighlightFieldNames(searchContext);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "city", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "country", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "emailAddress.text", false);
        this.queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "firstName", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "firstName", false);
        this.queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "fullName", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "fullName", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "jobTitle", false);
        this.queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "lastName", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "lastName", false);
        this.queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "middleName", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "middleName", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "region", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "screenName", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "screenName.text", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "street", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "zip", false);
        if (Validator.isNotNull((String)keywords)) {
            try {
                keywords = StringUtil.toLowerCase((String)keywords);
                booleanQuery.add((Query)this._getTrailingWildcardQuery("emailAddress", keywords), BooleanClauseOccur.SHOULD);
                booleanQuery.add((Query)this._getTrailingWildcardQuery("emailAddressDomain", keywords), BooleanClauseOccur.SHOULD);
                booleanQuery.add((Query)this._getTrailingWildcardQuery("screenName.text", keywords), BooleanClauseOccur.SHOULD);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
    }

    private void _addHighlightFieldNames(SearchContext searchContext) {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isHighlightEnabled()) {
            return;
        }
        queryConfig.addHighlightFieldNames(new String[]{"fullName"});
    }

    private WildcardQuery _getTrailingWildcardQuery(String field, String value) {
        return new WildcardQueryImpl(field, value + "*");
    }
}

