/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search;

import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.search.index.UpdateDocumentIndexWriter;
import com.liferay.portal.search.model.uid.UIDFactory;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=com.liferay.portal.kernel.model.User#lastLoginDate"}, service={Indexable.Callback.class})
public class UserLastLoginDateCallback
implements Indexable.Callback {
    @Reference
    private UIDFactory _uidFactory;
    @Reference
    private UpdateDocumentIndexWriter _updateDocumentIndexWriter;

    public void reindex(BaseModel<?> baseModel) {
        if (!(baseModel instanceof User)) {
            return;
        }
        User user = (User)baseModel;
        DocumentImpl document = new DocumentImpl();
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-36010")) {
            if (!Objects.equals(user.getLoginDate(), user.getLastLoginDate())) {
                return;
            }
            document.addKeyword("hasLoginDate", true);
        } else {
            document.add(new Field("entryClassName", user.getModelClassName()));
            document.add(new Field("entryClassPK", String.valueOf(user.getUserId())));
            document.addDate("modified", user.getModifiedDate());
            document.addDate("lastLoginDate", user.getLastLoginDate());
        }
        document.addKeyword("uid", this._uidFactory.getUID((ClassedModel)user));
        this._updateDocumentIndexWriter.updateDocumentPartially(user.getCompanyId(), (Document)document, false);
    }
}

