/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.OrgLabor;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PasswordPolicyRel;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.OrgLaborLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PasswordPolicyLocalService;
import com.liferay.portal.kernel.service.PasswordPolicyRelLocalService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class OrganizationStagedModelDataHandler
extends BaseStagedModelDataHandler<Organization> {
    public static final String[] CLASS_NAMES = new String[]{Organization.class.getName()};
    @Reference
    private AddressLocalService _addressLocalService;
    @Reference
    private CountryLocalService _countryLocalService;
    @Reference
    private EmailAddressLocalService _emailAddressLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private ListTypeLocalService _listTypeLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private OrgLaborLocalService _orgLaborLocalService;
    @Reference
    private PasswordPolicyLocalService _passwordPolicyLocalService;
    @Reference
    private PasswordPolicyRelLocalService _passwordPolicyRelLocalService;
    @Reference
    private PhoneLocalService _phoneLocalService;
    @Reference
    private WebsiteLocalService _websiteLocalService;

    public void deleteStagedModel(Organization organization) throws PortalException {
        this._organizationLocalService.deleteOrganization(organization);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        Organization organization = this._organizationLocalService.fetchOrganizationByUuidAndCompanyId(uuid, group.getCompanyId());
        if (organization != null) {
            this.deleteStagedModel(organization);
        }
    }

    public List<Organization> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new Organization[]{this._organizationLocalService.fetchOrganizationByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Organization organization) {
        return organization.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Organization organization) throws Exception {
        LinkedList<Organization> organizations = new LinkedList<Organization>();
        organizations.add(organization);
        while (!organizations.isEmpty()) {
            Organization exportedOrganization = (Organization)organizations.remove();
            if (exportedOrganization.getParentOrganizationId() != 0L) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)exportedOrganization, (StagedModel)exportedOrganization.getParentOrganization(), (String)"parent");
            }
            this._exportAddresses(portletDataContext, exportedOrganization);
            this._exportCountry(portletDataContext, exportedOrganization);
            this._exportEmailAddresses(portletDataContext, exportedOrganization);
            this._exportListType(portletDataContext, exportedOrganization);
            this._exportOrgLabors(portletDataContext, exportedOrganization);
            this._exportPasswordPolicyRel(portletDataContext, exportedOrganization);
            this._exportPhones(portletDataContext, exportedOrganization);
            this._exportWebsites(portletDataContext, exportedOrganization);
            Element organizationElement = portletDataContext.getExportDataElement((ClassedModel)exportedOrganization);
            portletDataContext.addClassedModel(organizationElement, ExportImportPathUtil.getModelPath((StagedModel)exportedOrganization), (ClassedModel)exportedOrganization);
            organizations.addAll(exportedOrganization.getSuborganizations());
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Organization organization) throws Exception {
        organization = this._importCountry(portletDataContext, organization);
        organization = this._importListType(portletDataContext, organization);
        long userId = portletDataContext.getUserId(organization.getUserUuid());
        Map organizationIds = portletDataContext.getNewPrimaryKeysMap(Organization.class);
        long parentOrganizationId = MapUtil.getLong((Map)organizationIds, (long)organization.getParentOrganizationId(), (long)organization.getParentOrganizationId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)organization);
        serviceContext.setUserId(userId);
        Organization existingOrganization = this._organizationLocalService.fetchOrganizationByUuidAndCompanyId(organization.getUuid(), portletDataContext.getGroupId());
        if (existingOrganization == null) {
            existingOrganization = this._organizationLocalService.fetchOrganization(portletDataContext.getCompanyId(), organization.getName());
        }
        Organization importedOrganization = null;
        if (existingOrganization == null) {
            serviceContext.setUuid(organization.getUuid());
            importedOrganization = this._organizationLocalService.addOrganization(null, userId, parentOrganizationId, organization.getName(), organization.getType(), organization.getRegionId(), organization.getCountryId(), organization.getStatusListTypeId(), organization.getComments(), false, serviceContext);
        } else {
            importedOrganization = this._organizationLocalService.updateOrganization(existingOrganization.getExternalReferenceCode(), portletDataContext.getCompanyId(), existingOrganization.getOrganizationId(), parentOrganizationId, organization.getName(), organization.getType(), organization.getRegionId(), organization.getCountryId(), organization.getStatusListTypeId(), organization.getComments(), true, null, false, serviceContext);
        }
        this._importAddresses(portletDataContext, organization, importedOrganization);
        this._importEmailAddresses(portletDataContext, organization, importedOrganization);
        this._importOrgLabors(portletDataContext, organization, importedOrganization);
        this._importPasswordPolicyRel(portletDataContext, organization, importedOrganization);
        this._importPhones(portletDataContext, organization, importedOrganization);
        this._importWebsites(portletDataContext, organization, importedOrganization);
        portletDataContext.importClassedModel((ClassedModel)organization, (ClassedModel)importedOrganization);
    }

    protected void importReferenceStagedModels(PortletDataContext portletDataContext, Organization organization) throws PortletDataException {
        if (organization.getParentOrganizationId() != 0L) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, Organization.class, (Serializable)Long.valueOf(organization.getParentOrganizationId()));
        }
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, Country.class, (Serializable)Long.valueOf(organization.getCountryId()));
    }

    private void _exportAddresses(PortletDataContext portletDataContext, Organization organization) throws Exception {
        List addresses = this._addressLocalService.getAddresses(organization.getCompanyId(), organization.getModelClassName(), organization.getOrganizationId());
        for (Address address : addresses) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)address, (String)"embedded");
        }
    }

    private void _exportCountry(PortletDataContext portletDataContext, Organization organization) throws Exception {
        if (organization.getCountryId() > 0L) {
            Country country = this._countryLocalService.getCountry(organization.getCountryId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)country, (String)"embedded");
        }
    }

    private void _exportEmailAddresses(PortletDataContext portletDataContext, Organization organization) throws Exception {
        List emailAddresses = this._emailAddressLocalService.getEmailAddresses(organization.getCompanyId(), organization.getModelClassName(), organization.getOrganizationId());
        for (EmailAddress emailAddress : emailAddresses) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)emailAddress, (String)"embedded");
        }
    }

    private void _exportListType(PortletDataContext portletDataContext, Organization organization) throws Exception {
        if (organization.getStatusListTypeId() > 0L) {
            ListType listType = this._listTypeLocalService.getListType(organization.getStatusListTypeId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)listType, (String)"embedded");
        }
    }

    private void _exportOrgLabors(PortletDataContext portletDataContext, Organization organization) {
        List orgLabors = this._orgLaborLocalService.getOrgLabors(organization.getOrganizationId());
        String path = ExportImportPathUtil.getModelPath((StagedModel)organization, (String)OrgLabor.class.getSimpleName());
        portletDataContext.addZipEntry(path, (Object)orgLabors);
    }

    private void _exportPasswordPolicyRel(PortletDataContext portletDataContext, Organization organization) throws Exception {
        PasswordPolicyRel passwordPolicyRel = this._passwordPolicyRelLocalService.fetchPasswordPolicyRel(Organization.class.getName(), organization.getOrganizationId());
        if (passwordPolicyRel == null) {
            return;
        }
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)this._passwordPolicyLocalService.getPasswordPolicy(passwordPolicyRel.getPasswordPolicyId()), (String)"strong");
    }

    private void _exportPhones(PortletDataContext portletDataContext, Organization organization) throws Exception {
        List phones = this._phoneLocalService.getPhones(organization.getCompanyId(), organization.getModelClassName(), organization.getOrganizationId());
        for (Phone phone : phones) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)phone, (String)"embedded");
        }
    }

    private void _exportWebsites(PortletDataContext portletDataContext, Organization organization) throws Exception {
        List websites = this._websiteLocalService.getWebsites(organization.getCompanyId(), organization.getModelClassName(), organization.getOrganizationId());
        for (Website website : websites) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)organization, (StagedModel)website, (String)"embedded");
        }
    }

    private void _importAddresses(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws Exception {
        List addressElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Address.class);
        ArrayList<Address> addresses = new ArrayList<Address>(addressElements.size());
        for (Element addressElement : addressElements) {
            String addressPath = addressElement.attributeValue("path");
            Address address = (Address)portletDataContext.getZipEntryAsObject(addressElement, addressPath);
            address.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)address);
            Map addressIds = portletDataContext.getNewPrimaryKeysMap(Address.class);
            address.setAddressId(((Long)addressIds.get(address.getPrimaryKey())).longValue());
            addresses.add(address);
        }
        UsersAdminUtil.updateAddresses((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), addresses);
    }

    private Organization _importCountry(PortletDataContext portletDataContext, Organization organization) throws Exception {
        List countryElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Country.class);
        for (Element countryElement : countryElements) {
            String countryPath = countryElement.attributeValue("path");
            Country country = (Country)portletDataContext.getZipEntryAsObject(countryPath);
            if (country == null) continue;
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)country);
            country = this._countryLocalService.getCountryByA2(portletDataContext.getCompanyId(), country.getA2());
            organization.setCountryId(country.getCountryId());
        }
        return organization;
    }

    private void _importEmailAddresses(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws Exception {
        List emailAddressElements = portletDataContext.getReferenceDataElements((StagedModel)organization, EmailAddress.class);
        ArrayList<EmailAddress> emailAddresses = new ArrayList<EmailAddress>(emailAddressElements.size());
        for (Element emailAddressElement : emailAddressElements) {
            String emailAddressPath = emailAddressElement.attributeValue("path");
            EmailAddress emailAddress = (EmailAddress)portletDataContext.getZipEntryAsObject(emailAddressElement, emailAddressPath);
            emailAddress.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)emailAddress);
            Map emailAddressIds = portletDataContext.getNewPrimaryKeysMap(EmailAddress.class);
            long emailAddressId = (Long)emailAddressIds.get(emailAddress.getPrimaryKey());
            emailAddress.setEmailAddressId(emailAddressId);
            emailAddresses.add(emailAddress);
        }
        UsersAdminUtil.updateEmailAddresses((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), emailAddresses);
    }

    private Organization _importListType(PortletDataContext portletDataContext, Organization organization) throws Exception {
        List listTypeElements = portletDataContext.getReferenceDataElements((StagedModel)organization, ListType.class);
        for (Element listTypeElement : listTypeElements) {
            String listTypePath = listTypeElement.attributeValue("path");
            ListType listType = (ListType)portletDataContext.getZipEntryAsObject(listTypePath);
            if (listType == null) continue;
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)listType);
            listType = this._listTypeLocalService.getListType(portletDataContext.getCompanyId(), listType.getName(), listType.getType());
            organization.setStatusListTypeId(listType.getListTypeId());
        }
        return organization;
    }

    private void _importOrgLabors(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws Exception {
        String path = ExportImportPathUtil.getModelPath((StagedModel)organization, (String)OrgLabor.class.getSimpleName());
        List orgLabors = (List)portletDataContext.getZipEntryAsObject(path);
        for (OrgLabor orgLabor : orgLabors) {
            orgLabor.setOrgLaborId(0L);
        }
        UsersAdminUtil.updateOrgLabors((long)importedOrganization.getOrganizationId(), (List)orgLabors);
    }

    private void _importPasswordPolicyRel(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws Exception {
        List passwordPolicyElements = portletDataContext.getReferenceDataElements((StagedModel)organization, PasswordPolicy.class);
        if (passwordPolicyElements.isEmpty()) {
            return;
        }
        Element passwordPolicyElement = (Element)passwordPolicyElements.get(0);
        String passwordPolicyPath = passwordPolicyElement.attributeValue("path");
        PasswordPolicy passwordPolicy = (PasswordPolicy)portletDataContext.getZipEntryAsObject(passwordPolicyPath);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)passwordPolicy);
        Map passwordPolicyIds = portletDataContext.getNewPrimaryKeysMap(PasswordPolicy.class);
        long passwordPolicyId = (Long)passwordPolicyIds.get(passwordPolicy.getPrimaryKey());
        this._organizationLocalService.addPasswordPolicyOrganizations(passwordPolicyId, new long[]{importedOrganization.getOrganizationId()});
    }

    private void _importPhones(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws Exception {
        List phoneElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Phone.class);
        ArrayList<Phone> phones = new ArrayList<Phone>(phoneElements.size());
        for (Element phoneElement : phoneElements) {
            String phonePath = phoneElement.attributeValue("path");
            Phone phone = (Phone)portletDataContext.getZipEntryAsObject(phoneElement, phonePath);
            phone.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)phone);
            Map phoneIds = portletDataContext.getNewPrimaryKeysMap(Phone.class);
            phone.setPhoneId(((Long)phoneIds.get(phone.getPrimaryKey())).longValue());
            phones.add(phone);
        }
        UsersAdminUtil.updatePhones((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), phones);
    }

    private void _importWebsites(PortletDataContext portletDataContext, Organization organization, Organization importedOrganization) throws Exception {
        List websiteElements = portletDataContext.getReferenceDataElements((StagedModel)organization, Website.class);
        ArrayList<Website> websites = new ArrayList<Website>(websiteElements.size());
        for (Element websiteElement : websiteElements) {
            String websitePath = websiteElement.attributeValue("path");
            Website website = (Website)portletDataContext.getZipEntryAsObject(websiteElement, websitePath);
            website.setClassPK(importedOrganization.getOrganizationId());
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)website);
            Map websiteIds = portletDataContext.getNewPrimaryKeysMap(Website.class);
            website.setWebsiteId(((Long)websiteIds.get(website.getPrimaryKey())).longValue());
            websites.add(website);
        }
        UsersAdminUtil.updateWebsites((String)Organization.class.getName(), (long)importedOrganization.getOrganizationId(), websites);
    }
}

