/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;
import com.liferay.users.admin.internal.search.ContactBatchReindexer;

public class UserModelIndexerWriterContributor
implements ModelIndexerWriterContributor<User> {
    private final ContactBatchReindexer _contactBatchReindexer;
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    private final UserLocalService _userLocalService;

    public UserModelIndexerWriterContributor(ContactBatchReindexer contactBatchReindexer, DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory, UserLocalService userLocalService) {
        this._contactBatchReindexer = contactBatchReindexer;
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
        this._userLocalService = userLocalService;
    }

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setPerformActionMethod(user -> {
            if (!user.isGuestUser()) {
                batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)user)});
            }
        });
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this._userLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(User user) {
        return user.getCompanyId();
    }

    public void modelIndexed(User user) {
        this._contactBatchReindexer.reindex(user.getUserId(), user.getCompanyId());
    }
}

