/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search;

import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.indexer.IndexerDocumentBuilder;
import com.liferay.portal.search.indexer.IndexerWriter;

public class ContactBatchReindexer {
    private final ClassNameLocalService _classNameLocalService;
    private final IndexerDocumentBuilder _indexerDocumentBuilder;
    private final IndexerWriter<Contact> _indexerWriter;

    public ContactBatchReindexer(ClassNameLocalService classNameLocalService, IndexerDocumentBuilder indexerDocumentBuilder, IndexerWriter<Contact> indexerWriter) {
        this._classNameLocalService = classNameLocalService;
        this._indexerDocumentBuilder = indexerDocumentBuilder;
        this._indexerWriter = indexerWriter;
    }

    public void reindex(long userId, long companyId) {
        BatchIndexingActionable batchIndexingActionable = this._indexerWriter.getBatchIndexingActionable();
        batchIndexingActionable.setAddCriteriaMethod(dynamicQuery -> {
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.eq((Object)this._classNameLocalService.getClassNameId(User.class)));
            Property classPKProperty = PropertyFactoryUtil.forName((String)"classPK");
            dynamicQuery.add(classPKProperty.eq((Object)userId));
        });
        batchIndexingActionable.setCompanyId(companyId);
        batchIndexingActionable.setPerformActionMethod(contact -> batchIndexingActionable.addDocuments(new Document[]{this._indexerDocumentBuilder.getDocument((BaseModel)contact)}));
        batchIndexingActionable.performActions();
    }
}

