/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class CountryStagedModelDataHandler
extends BaseStagedModelDataHandler<Country> {
    public static final String[] CLASS_NAMES = new String[]{Country.class.getName()};
    @Reference
    private CountryLocalService _countryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public void deleteStagedModel(Country country) throws PortalException {
        this._countryLocalService.deleteCountry(country.getCountryId());
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        Country country = this._countryLocalService.getCountryByUuidAndCompanyId(uuid, group.getCompanyId());
        if (country != null) {
            this.deleteStagedModel(country);
        }
    }

    public List<Country> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new Country[]{this._countryLocalService.fetchCountryByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Country country) throws Exception {
        Element countryElement = portletDataContext.getExportDataElement((ClassedModel)country);
        portletDataContext.addClassedModel(countryElement, ExportImportPathUtil.getModelPath((StagedModel)country), (ClassedModel)country);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Country country) throws Exception {
        Country existingCountry = this._countryLocalService.fetchCountryByA2(country.getCompanyId(), country.getA2());
        Country importedCountry = null;
        if (existingCountry == null) {
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)country);
            serviceContext.setUuid(country.getUuid());
            importedCountry = this._countryLocalService.addCountry(country.getA2(), country.getA3(), country.isActive(), country.isBillingAllowed(), country.getIdd(), country.getName(), country.getNumber(), country.getPosition(), country.isShippingAllowed(), country.isSubjectToVAT(), country.isZipRequired(), serviceContext);
        } else {
            importedCountry = this._countryLocalService.updateCountry(country.getCountryId(), country.getA2(), country.getA3(), country.isActive(), country.isBillingAllowed(), country.getIdd(), country.getName(), country.getNumber(), country.getPosition(), country.isShippingAllowed(), country.isSubjectToVAT());
        }
        portletDataContext.importClassedModel((ClassedModel)country, (ClassedModel)importedCountry);
    }
}

