/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.workflow;

import com.liferay.portal.kernel.audit.AuditRequestThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.model.User"}, service={WorkflowHandler.class})
public class UserWorkflowHandler
extends BaseWorkflowHandler<User> {
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public String getClassName() {
        return User.class.getName();
    }

    public String getType(Locale locale) {
        return ResourceActionsUtil.getModelResource((Locale)locale, (String)this.getClassName());
    }

    public boolean isScopeable() {
        return false;
    }

    public User updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        User user = this._userLocalService.getUser(userId);
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        if ((user.getStatus() == 2 || user.getStatus() == 1) && status == 0) {
            this._userLocalService.completeUserRegistration(user, serviceContext);
            this._updateAuditRequestThreadLocal(workflowContext);
        }
        return this._userLocalService.updateStatus(userId, status, serviceContext);
    }

    private void _updateAuditRequestThreadLocal(Map<String, Serializable> workflowContext) {
        HttpServletRequest httpServletRequest;
        AuditRequestThreadLocal auditRequestThreadLocal = AuditRequestThreadLocal.getAuditThreadLocal();
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        auditRequestThreadLocal.setClientHost(serviceContext.getRemoteHost());
        auditRequestThreadLocal.setClientIP(serviceContext.getRemoteAddr());
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        if (userId != 0L) {
            auditRequestThreadLocal.setRealUserId(userId);
        }
        if ((httpServletRequest = this._portal.getOriginalServletRequest(serviceContext.getRequest())) == null) {
            return;
        }
        auditRequestThreadLocal.setServerName(httpServletRequest.getServerName());
        auditRequestThreadLocal.setServerPort(httpServletRequest.getServerPort());
        HttpSession httpSession = httpServletRequest.getSession();
        if (httpSession == null) {
            return;
        }
        auditRequestThreadLocal.setSessionID(httpSession.getId());
    }
}

