/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search.spi.model.index.contributor;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.TeamLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={ModelDocumentContributor.class})
public class UserModelDocumentContributor
implements ModelDocumentContributor<User> {
    @Reference
    protected CountryService countryService;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    @Reference
    protected OrganizationLocalService organizationLocalService;
    @Reference
    protected RegionService regionService;
    @Reference
    protected UserGroupRoleLocalService userGroupRoleLocalService;
    private static final Log _log = LogFactoryUtil.getLog(UserModelDocumentContributor.class);
    @Reference
    private Language _language;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TeamLocalService _teamLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;

    public void contribute(Document document, User user) {
        block2: {
            try {
                long[] organizationIds = user.getOrganizationIds();
                long[] activeTransitiveGroupIds = this._getActiveTransitiveGroupIds(user.getUserId());
                document.addKeyword("companyId", user.getCompanyId());
                document.addKeyword("groupId", activeTransitiveGroupIds);
                document.addDate("modified", user.getModifiedDate());
                document.addKeyword("scopeGroupId", activeTransitiveGroupIds);
                document.addKeyword("status", user.getStatus());
                document.addKeyword("type", user.getType());
                document.addKeyword("userId", user.getUserId());
                document.addKeyword("userName", user.getFullName(), true);
                document.addKeyword("ancestorOrganizationIds", this._getAncestorOrganizationIds(user.getOrganizationIds()));
                document.addDate("birthDate", user.getBirthday());
                document.addKeyword("defaultUser", user.isDefaultUser());
                document.addKeyword("emailAddress", user.getEmailAddress());
                document.addKeyword("emailAddressDomain", this._getEmailAddressDomain(user.getEmailAddress()));
                document.addText("firstName", user.getFirstName());
                document.addText("fullName", user.getFullName());
                document.addKeyword("groupIds", user.getGroupIds());
                document.addText("jobTitle", user.getJobTitle());
                document.addDate("lastLoginDate", user.getLastLoginDate());
                document.addText("lastName", user.getLastName());
                document.addText("middleName", user.getMiddleName());
                document.addKeyword("organizationIds", organizationIds);
                document.addKeyword("organizationCount", String.valueOf(organizationIds.length));
                long[] roleIds = user.getRoleIds();
                document.addKeyword("roleIds", roleIds);
                document.addKeyword("roleNames", (String[])ListUtil.toArray((List)this._roleLocalService.getRoles(roleIds), (Accessor)Role.NAME_ACCESSOR));
                document.addText("screenName", user.getScreenName());
                document.addKeyword("teamIds", this._getTeamIds(user));
                document.addKeyword("userGroupIds", user.getUserGroupIds());
                long[] userGroupRoleIds = this._getUserGroupRoleIds(user.getUserId());
                document.addKeyword("userGroupRoleIds", userGroupRoleIds);
                document.addKeyword("userGroupRoleNames", (String[])ListUtil.toArray((List)this._roleLocalService.getRoles(userGroupRoleIds), (Accessor)Role.NAME_ACCESSOR));
                this._populateAddresses(document, user.getAddresses(), 0L, 0L);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to index user " + user.getUserId()), (Throwable)exception);
            }
        }
    }

    private long[] _getActiveTransitiveGroupIds(long userId) throws PortalException {
        return ArrayUtil.toLongArray((Collection)TransformUtil.transform((Collection)this.groupLocalService.getUserGroups(userId, true), group -> {
            if (group.isActive() && group.isSite()) {
                return group.getGroupId();
            }
            return null;
        }));
    }

    private long[] _getAncestorOrganizationIds(long[] organizationIds) throws Exception {
        HashSet<Long> ancestorOrganizationIds = new HashSet<Long>();
        for (long organizationId : organizationIds) {
            Organization organization = this.organizationLocalService.getOrganization(organizationId);
            for (long ancestorOrganizationId : organization.getAncestorOrganizationIds()) {
                ancestorOrganizationIds.add(ancestorOrganizationId);
            }
        }
        return ArrayUtil.toLongArray(ancestorOrganizationIds);
    }

    private String _getEmailAddressDomain(String emailAddress) {
        return emailAddress.substring(emailAddress.indexOf("@") + 1);
    }

    private Set<String> _getLocalizedCountryNames(Country country) {
        HashSet<String> countryNames = new HashSet<String>();
        for (Locale locale : this._language.getAvailableLocales()) {
            String countryName = country.getName(locale);
            countryName = StringUtil.toLowerCase((String)countryName);
            countryNames.add(countryName);
        }
        return countryNames;
    }

    private long[] _getTeamIds(User user) {
        long[] userGroupIds = user.getUserGroupIds();
        if (userGroupIds.length == 0) {
            return user.getTeamIds();
        }
        long[] teamIds = user.getTeamIds();
        for (long userGroupId : user.getUserGroupIds()) {
            teamIds = ArrayUtil.append((long[][])new long[][]{teamIds, this._userGroupLocalService.getTeamPrimaryKeys(userGroupId)});
        }
        return teamIds;
    }

    private long[] _getUserGroupRoleIds(long userId) {
        HashSet<Long> userGroupRoleIds = new HashSet<Long>();
        for (UserGroupRole userGroupRole : this.userGroupRoleLocalService.getUserGroupRoles(userId)) {
            userGroupRoleIds.add(userGroupRole.getRoleId());
        }
        return ArrayUtil.toLongArray(userGroupRoleIds);
    }

    private void _populateAddresses(Document document, List<Address> addresses, long regionId, long countryId) throws PortalException {
        ArrayList<String> regions;
        ArrayList<String> countries;
        ArrayList<String> cities;
        block8: {
            block7: {
                cities = new ArrayList<String>();
                countries = new ArrayList<String>();
                if (countryId > 0L) {
                    try {
                        countries.addAll(this._getLocalizedCountryNames(this.countryService.getCountry(countryId)));
                    }
                    catch (NoSuchCountryException noSuchCountryException) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Throwable)noSuchCountryException);
                    }
                }
            }
            regions = new ArrayList<String>();
            if (regionId > 0L) {
                try {
                    Region region = this.regionService.getRegion(regionId);
                    regions.add(StringUtil.toLowerCase((String)region.getName()));
                }
                catch (NoSuchRegionException noSuchRegionException) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Throwable)noSuchRegionException);
                }
            }
        }
        ArrayList<String> streets = new ArrayList<String>();
        ArrayList<String> zips = new ArrayList<String>();
        for (Address address : addresses) {
            cities.add(StringUtil.toLowerCase((String)address.getCity()));
            countries.addAll(this._getLocalizedCountryNames(address.getCountry()));
            Region region = address.getRegion();
            regions.add(StringUtil.toLowerCase((String)region.getName()));
            streets.add(StringUtil.toLowerCase((String)address.getStreet1()));
            streets.add(StringUtil.toLowerCase((String)address.getStreet2()));
            streets.add(StringUtil.toLowerCase((String)address.getStreet3()));
            zips.add(StringUtil.toLowerCase((String)address.getZip()));
        }
        document.addText("city", cities.toArray(new String[0]));
        document.addText("country", countries.toArray(new String[0]));
        document.addText("region", regions.toArray(new String[0]));
        document.addText("street", streets.toArray(new String[0]));
        document.addText("zip", zips.toArray(new String[0]));
    }
}

