/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.users.admin.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.RequiredUserException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserConstants;
import com.liferay.portal.util.PortalInstances;

import org.osgi.service.component.annotations.Component;

/**
 * @author Pei-Jung Lan
 */
@Component(service = ModelListener.class)
public class UserModelListener extends BaseModelListener<User> {

	@Override
	public void onBeforeRemove(User user) throws ModelListenerException {
		if (PortalInstances.isCurrentCompanyInDeletionProcess()) {
			return;
		}

		if (user.getType() == UserConstants.TYPE_DEFAULT_SERVICE_ACCOUNT) {
			throw new ModelListenerException(
				new RequiredUserException(
					"Default service account cannot be removed"));
		}
	}

	@Override
	public void onBeforeUpdate(User originalUser, User user)
		throws ModelListenerException {

		if (originalUser.getType() != user.getType()) {
			throw new ModelListenerException("User's type cannot be changed");
		}

		if ((originalUser.getType() ==
				UserConstants.TYPE_DEFAULT_SERVICE_ACCOUNT) &&
			(originalUser.getScreenName() != user.getScreenName())) {

			throw new ModelListenerException(
				new RequiredUserException(
					"Screen name for default service account cannot be " +
						"changed"));
		}
	}

}