/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search;

import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.search.spi.reindexer.BulkReindexer;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={BulkReindexer.class})
public class UserBulkReindexer
implements BulkReindexer {
    @Reference(target="(indexer.class.name=com.liferay.portal.kernel.model.User)")
    protected Indexer<User> indexer;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(UserBulkReindexer.class);

    public void reindex(long companyId, Collection<Long> classPKs) {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.userLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.in((String)"userId", (Collection)classPKs)));
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(user -> {
            block3: {
                if (!user.isGuestUser()) {
                    try {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{this.indexer.getDocument(user)});
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to index user " + user.getUserId()), (Throwable)portalException);
                    }
                }
            }
        });
        try {
            indexableActionableDynamicQuery.performActions();
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }
}

