/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.users.admin.internal.security.permission.wrapper;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.wrapper.PermissionCheckerWrapper;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.function.Supplier;

/**
 * @author Pei-Jung Lan
 */
public class ServiceAccountUserPermissionCheckerWrapper
	extends PermissionCheckerWrapper {

	public ServiceAccountUserPermissionCheckerWrapper(
		PermissionChecker permissionChecker,
		UserLocalService userLocalService) {

		super(permissionChecker);

		_permissionChecker = permissionChecker;
		_userLocalService = userLocalService;
	}

	@Override
	public boolean hasPermission(
		Group group, String name, long primKey, String actionId) {

		return _hasPermission(
			name, primKey,
			() -> super.hasPermission(group, name, primKey, actionId));
	}

	@Override
	public boolean hasPermission(
		Group group, String name, String primKey, String actionId) {

		return _hasPermission(
			name, GetterUtil.getLong(primKey),
			() -> super.hasPermission(group, name, primKey, actionId));
	}

	@Override
	public boolean hasPermission(
		long groupId, String name, long primKey, String actionId) {

		return _hasPermission(
			name, primKey,
			() -> super.hasPermission(groupId, name, primKey, actionId));
	}

	@Override
	public boolean hasPermission(
		long groupId, String name, String primKey, String actionId) {

		return _hasPermission(
			name, GetterUtil.getLong(primKey),
			() -> super.hasPermission(groupId, name, primKey, actionId));
	}

	private boolean _hasPermission(
		String name, long primKey, Supplier<Boolean> hasPermissionSupplier) {

		if (!StringUtil.equals(name, User.class.getName())) {
			return hasPermissionSupplier.get();
		}

		User user = _userLocalService.fetchUser(primKey);

		if ((user != null) && user.isServiceAccountUser() &&
			!_permissionChecker.isCompanyAdmin()) {

			return false;
		}

		return hasPermissionSupplier.get();
	}

	private final PermissionChecker _permissionChecker;
	private final UserLocalService _userLocalService;

}