/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class WebsiteStagedModelDataHandler
extends BaseStagedModelDataHandler<Website> {
    public static final String[] CLASS_NAMES = new String[]{Website.class.getName()};
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private WebsiteLocalService _websiteLocalService;

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        Website website = this._websiteLocalService.fetchWebsiteByUuidAndCompanyId(uuid, group.getCompanyId());
        if (website != null) {
            this.deleteStagedModel(website);
        }
    }

    public void deleteStagedModel(Website website) {
        this._websiteLocalService.deleteWebsite(website);
    }

    public List<Website> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new Website[]{this._websiteLocalService.fetchWebsiteByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Website website) throws Exception {
        Element websiteElement = portletDataContext.getExportDataElement((ClassedModel)website);
        portletDataContext.addClassedModel(websiteElement, ExportImportPathUtil.getModelPath((StagedModel)website), (ClassedModel)website);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Website website) throws Exception {
        long userId = portletDataContext.getUserId(website.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)website);
        Website existingWebsite = this._websiteLocalService.fetchWebsiteByUuidAndCompanyId(website.getUuid(), portletDataContext.getCompanyGroupId());
        Website importedWebsite = null;
        if (existingWebsite == null) {
            serviceContext.setUuid(website.getUuid());
            importedWebsite = this._websiteLocalService.addWebsite(userId, website.getClassName(), website.getClassPK(), website.getUrl(), website.getListTypeId(), website.isPrimary(), serviceContext);
        } else {
            importedWebsite = this._websiteLocalService.updateWebsite(existingWebsite.getWebsiteId(), website.getUrl(), website.getListTypeId(), website.isPrimary());
        }
        portletDataContext.importClassedModel((ClassedModel)website, (ClassedModel)importedWebsite);
    }
}

