/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.users.admin.internal.data.engine.nativeobject;

import com.liferay.data.engine.nativeobject.DataEngineNativeObject;
import com.liferay.data.engine.nativeobject.DataEngineNativeObjectField;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.util.ListUtil;

import java.util.List;

import org.osgi.service.component.annotations.Component;

/**
 * @author Jeyvison Nascimento
 */
@Component(immediate = true, service = DataEngineNativeObject.class)
public class UserDataEngineNativeObject implements DataEngineNativeObject {

	@Override
	public String getClassName() {
		return User.class.getName();
	}

	@Override
	public List<DataEngineNativeObjectField> getDataEngineNativeObjectFields() {
		return ListUtil.fromArray(
			new DataEngineNativeObjectField(
				UserTable.INSTANCE.emailAddress, "Email Address", null),
			new DataEngineNativeObjectField(
				UserTable.INSTANCE.firstName, "First Name", null),
			new DataEngineNativeObjectField(
				UserTable.INSTANCE.jobTitle, "Job Title", null),
			new DataEngineNativeObjectField(
				UserTable.INSTANCE.lastName, "Last Name", null),
			new DataEngineNativeObjectField(
				UserTable.INSTANCE.middleName, "Middle Name", null));
	}

	@Override
	public String getName() {
		return "User";
	}

}