/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search.spi.model.permission.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.search.spi.model.permission.SearchPermissionFilterContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={SearchPermissionFilterContributor.class})
public class UserSearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    @Reference
    protected RoleLocalService roleLocalService;
    private static final Log _log = LogFactoryUtil.getLog(UserSearchPermissionFilterContributor.class);

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        if (!className.equals(User.class.getName())) {
            return;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null && permissionChecker.isGroupAdmin(serviceContext.getScopeGroupId())) {
            try {
                TermsFilter roleIdsTermsFilter = new TermsFilter("roleIds");
                Role role = this.roleLocalService.getRole(companyId, "User");
                roleIdsTermsFilter.addValue(String.valueOf(role.getRoleId()));
                booleanFilter.add((Filter)roleIdsTermsFilter);
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to get the User role for company " + companyId), (Throwable)portalException);
            }
        }
    }
}

