/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.user.initials.generator;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.users.admin.kernel.util.UserInitialsGenerator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={UserInitialsGenerator.class})
public class UserInitialsGeneratorImpl
implements UserInitialsGenerator {
    private static final String[] _DEFAULT_USER_INITIALS_FIELD_NAMES = new String[]{"first-name", "last-name"};
    private static final Map<String, Integer> _userNameIndexes = HashMapBuilder.put((Object)"first-name", (Object)0).put((Object)"last-name", (Object)2).put((Object)"middle-name", (Object)1).build();
    private final Map<Locale, String[]> _userInitialsFieldNamesMap = new HashMap<Locale, String[]>();

    public String getInitials(Locale locale, String firstName, String middleName, String lastName) {
        String[] userNames = new String[]{firstName, middleName, lastName};
        return Stream.of(this._getUserInitialsFieldNames(locale)).map(key -> userNames[_userNameIndexes.get(key)]).filter(name -> Validator.isNotNull((String)name)).limit(2L).map(name -> StringUtil.shorten((String)name, (int)1)).map(initial -> StringUtil.toUpperCase((String)initial)).collect(Collectors.joining());
    }

    public String getInitials(User user) {
        return this.getInitials(user.getLocale(), user.getFirstName(), user.getMiddleName(), user.getLastName());
    }

    private String[] _getUserInitialsFieldNames(Locale locale) {
        Object[] userInitialsFieldNames = this._userInitialsFieldNamesMap.get(locale);
        if (userInitialsFieldNames != null) {
            return userInitialsFieldNames;
        }
        userInitialsFieldNames = StringUtil.split((String)LanguageUtil.get((Locale)locale, (String)"lang.user.initials.field.names", null));
        if (ArrayUtil.isEmpty((Object[])userInitialsFieldNames)) {
            userInitialsFieldNames = _DEFAULT_USER_INITIALS_FIELD_NAMES;
        }
        this._userInitialsFieldNamesMap.put(locale, (String[])userInitialsFieldNames);
        return userInitialsFieldNames;
    }
}

