/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;
import com.liferay.users.admin.internal.search.ContactBatchReindexer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={ModelIndexerWriterContributor.class})
public class UserModelIndexerWriterContributor
implements ModelIndexerWriterContributor<User> {
    @Reference
    protected ContactBatchReindexer contactBatchReindexer;
    @Reference
    protected DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory;
    @Reference
    protected UserLocalService userLocalService;

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setPerformActionMethod(user -> {
            if (!user.isDefaultUser()) {
                batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)user)});
            }
        });
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this.dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this.userLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(User user) {
        return user.getCompanyId();
    }

    public void modelIndexed(User user) {
        this.contactBatchReindexer.reindex(user.getUserId(), user.getCompanyId());
    }
}

