/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search.spi.model.permission.contributor;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.service.ContactLocalService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.permission.SearchPermissionFilterContributor;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={SearchPermissionFilterContributor.class})
public class UserSearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    private static final Log _log = LogFactoryUtil.getLog(UserSearchPermissionFilterContributor.class);
    @Reference
    private ContactLocalService _contactLocalService;
    @Reference
    private Portal _portal;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        if (!className.equals(User.class.getName())) {
            return;
        }
        this._addManagedOrganizationUsersFilter(booleanFilter, permissionChecker);
        this._addOwnedUsersFilter(booleanFilter, userId);
    }

    private void _addManagedOrganizationUsersFilter(BooleanFilter booleanFilter, PermissionChecker permissionChecker) {
        block4: {
            try {
                long[] userOrgIds;
                TermsFilter termsFilter = new TermsFilter("organizationIds");
                UserBag userBag = permissionChecker.getUserBag();
                for (long userOrgId : userOrgIds = userBag.getUserOrgIds()) {
                    if (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userOrgId, (String)"MANAGE_USERS")) continue;
                    termsFilter.addValue(String.valueOf(userOrgId));
                }
                if (!termsFilter.isEmpty()) {
                    booleanFilter.add((Filter)termsFilter);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
    }

    private void _addOwnedUsersFilter(BooleanFilter booleanFilter, long userId) {
        TermsFilter termsFilter = new TermsFilter("entryClassPK");
        DynamicQuery dynamicQuery = this._contactLocalService.dynamicQuery();
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"classNameId", (Object)this._portal.getClassNameId(User.class)));
        dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"userId", (Object)userId));
        dynamicQuery.setProjection(ProjectionFactoryUtil.distinct((Projection)ProjectionFactoryUtil.property((String)"classPK")));
        List classPKs = this._contactLocalService.dynamicQuery(dynamicQuery);
        for (Long classPK : classPKs) {
            termsFilter.addValue(String.valueOf(classPK));
        }
        if (!termsFilter.isEmpty()) {
            booleanFilter.add((Filter)termsFilter);
        }
    }
}

