/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.exception.NoSuchCountryException;
import com.liferay.portal.kernel.exception.NoSuchRegionException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={ModelDocumentContributor.class})
public class UserModelDocumentContributor
implements ModelDocumentContributor<User> {
    @Reference
    protected CountryService countryService;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    @Reference
    protected OrganizationLocalService organizationLocalService;
    @Reference
    protected RegionService regionService;
    private static final Log _log = LogFactoryUtil.getLog(UserModelDocumentContributor.class);

    public void contribute(Document document, User user) {
        block2: {
            try {
                long[] organizationIds = user.getOrganizationIds();
                document.addKeyword("companyId", user.getCompanyId());
                document.addKeyword("groupId", this.getActiveTransitiveGroupIds(user.getUserId()));
                document.addDate("modified", user.getModifiedDate());
                document.addKeyword("scopeGroupId", this.getActiveTransitiveGroupIds(user.getUserId()));
                document.addKeyword("status", user.getStatus());
                document.addKeyword("userId", user.getUserId());
                document.addKeyword("userName", user.getFullName(), true);
                document.addKeyword("ancestorOrganizationIds", this.getAncestorOrganizationIds(user.getOrganizationIds()));
                document.addKeyword("defaultUser", user.isDefaultUser());
                document.addText("emailAddress", user.getEmailAddress());
                document.addText("firstName", user.getFirstName());
                document.addText("fullName", user.getFullName());
                document.addKeyword("groupIds", user.getGroupIds());
                document.addText("jobTitle", user.getJobTitle());
                document.addText("lastName", user.getLastName());
                document.addText("middleName", user.getMiddleName());
                document.addKeyword("organizationIds", organizationIds);
                document.addKeyword("organizationCount", String.valueOf(organizationIds.length));
                document.addKeyword("roleIds", user.getRoleIds());
                document.addText("screenName", user.getScreenName());
                document.addKeyword("teamIds", user.getTeamIds());
                document.addKeyword("userGroupIds", user.getUserGroupIds());
                this.populateAddresses(document, user.getAddresses(), 0L, 0L);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to index user " + user.getUserId()), (Throwable)exception);
            }
        }
    }

    protected long[] getActiveGroupIds(long userId) {
        List groupIds = this.groupLocalService.getActiveGroupIds(userId);
        return ArrayUtil.toArray((Long[])groupIds.toArray(new Long[0]));
    }

    protected long[] getActiveTransitiveGroupIds(long userId) throws PortalException {
        List groups = this.groupLocalService.getUserGroups(userId, true);
        Stream stream = groups.stream();
        return stream.filter(GroupModel::isSite).filter(GroupModel::isActive).mapToLong(GroupModel::getGroupId).toArray();
    }

    protected long[] getAncestorOrganizationIds(long[] organizationIds) throws Exception {
        HashSet<Long> ancestorOrganizationIds = new HashSet<Long>();
        for (long organizationId : organizationIds) {
            Organization organization = this.organizationLocalService.getOrganization(organizationId);
            for (long ancestorOrganizationId : organization.getAncestorOrganizationIds()) {
                ancestorOrganizationIds.add(ancestorOrganizationId);
            }
        }
        return ArrayUtil.toLongArray(ancestorOrganizationIds);
    }

    protected Set<String> getLocalizedCountryNames(Country country) {
        HashSet<String> countryNames = new HashSet<String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            String countryName = country.getName(locale);
            countryName = StringUtil.toLowerCase((String)countryName);
            countryNames.add(countryName);
        }
        return countryNames;
    }

    protected void populateAddresses(Document document, List<Address> addresses, long regionId, long countryId) throws PortalException {
        ArrayList<String> regions;
        ArrayList<String> countries;
        ArrayList<String> cities;
        block8: {
            block7: {
                cities = new ArrayList<String>();
                countries = new ArrayList<String>();
                if (countryId > 0L) {
                    try {
                        countries.addAll(this.getLocalizedCountryNames(this.countryService.getCountry(countryId)));
                    }
                    catch (NoSuchCountryException noSuchCountryException) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Object)noSuchCountryException.getMessage());
                    }
                }
            }
            regions = new ArrayList<String>();
            if (regionId > 0L) {
                try {
                    Region region = this.regionService.getRegion(regionId);
                    regions.add(StringUtil.toLowerCase((String)region.getName()));
                }
                catch (NoSuchRegionException noSuchRegionException) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)noSuchRegionException.getMessage());
                }
            }
        }
        ArrayList<String> streets = new ArrayList<String>();
        ArrayList<String> zips = new ArrayList<String>();
        for (Address address : addresses) {
            cities.add(StringUtil.toLowerCase((String)address.getCity()));
            countries.addAll(this.getLocalizedCountryNames(address.getCountry()));
            Region region = address.getRegion();
            regions.add(StringUtil.toLowerCase((String)region.getName()));
            streets.add(StringUtil.toLowerCase((String)address.getStreet1()));
            streets.add(StringUtil.toLowerCase((String)address.getStreet2()));
            streets.add(StringUtil.toLowerCase((String)address.getStreet3()));
            zips.add(StringUtil.toLowerCase((String)address.getZip()));
        }
        document.addText("city", cities.toArray(new String[0]));
        document.addText("country", countries.toArray(new String[0]));
        document.addText("region", regions.toArray(new String[0]));
        document.addText("street", streets.toArray(new String[0]));
        document.addText("zip", zips.toArray(new String[0]));
    }
}

