/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.address.internal.portal.instance.lifecycle;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CountryService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.SimplePermissionChecker;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class PortalInstanceLifecycleListenerImpl
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(PortalInstanceLifecycleListenerImpl.class);
    private static final PermissionChecker _permissionChecker = new SimplePermissionChecker(){

        public boolean isOmniadmin() {
            return true;
        }
    };
    @Reference
    private CountryService _countryService;
    @Reference
    private JSONFactory _jsonFactory;

    public void portalInstanceRegistered(Company company) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)_permissionChecker);
            this.doPortalInstanceRegistered(company);
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    protected void doPortalInstanceRegistered(Company company) throws Exception {
        List countries = this._countryService.getCountries();
        if (!countries.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Skipping country initialization. Countries are ", "already initialized for company ", company.getCompanyId(), "."}));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Initializing countries for company " + company.getCompanyId()));
        }
        JSONArray countriesJSONArray = this._getJSONArray("com/liferay/users/admin/internal/address/dependencies/countries.json");
        for (int i = 0; i < countriesJSONArray.length(); ++i) {
            JSONObject countryJSONObject = countriesJSONArray.getJSONObject(i);
            try {
                String name = countryJSONObject.getString("name");
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setCompanyId(company.getCompanyId());
                User defaultUser = company.getDefaultUser();
                serviceContext.setUserId(defaultUser.getUserId());
                this._countryService.addCountry(name, countryJSONObject.getString("a2"), countryJSONObject.getString("a3"), countryJSONObject.getString("number"), countryJSONObject.getString("idd"), countryJSONObject.getBoolean("active"));
                continue;
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)exception.getMessage());
            }
        }
    }

    private JSONArray _getJSONArray(String filePath) throws Exception {
        String regionsJSON = StringUtil.read((ClassLoader)this.getClassLoader(), (String)filePath, (boolean)false);
        return this._jsonFactory.createJSONArray(regionsJSON);
    }
}

