/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.address.internal.model.listener;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.RegionService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.SimplePermissionChecker;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class CountryModelListener
extends BaseModelListener<Country> {
    private static final Log _log = LogFactoryUtil.getLog(CountryModelListener.class);
    private static final PermissionChecker _permissionChecker = new SimplePermissionChecker(){

        public boolean isOmniadmin() {
            return true;
        }
    };
    private final ClassLoader _classLoader = CountryModelListener.class.getClassLoader();
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private RegionService _regionService;
    @Reference
    private UserLocalService _userLocalService;

    public void onAfterCreate(Country country) throws ModelListenerException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)_permissionChecker);
            this._processCountryRegions(country);
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private JSONArray _getJSONArray(String filePath) throws Exception {
        String regionsJSON = StringUtil.read((ClassLoader)this._classLoader, (String)filePath, (boolean)false);
        return this._jsonFactory.createJSONArray(regionsJSON);
    }

    private void _processCountryRegions(Country country) {
        block7: {
            String a2 = country.getA2();
            try {
                String path = StringBundler.concat((String[])new String[]{"com/liferay/users/admin/internal/address/dependencies/regions", "/", a2, ".json"});
                if (this._classLoader.getResource(path) == null) {
                    return;
                }
                JSONArray regionsJSONArray = this._getJSONArray(path);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Regions found for country " + a2));
                }
                for (int i = 0; i < regionsJSONArray.length(); ++i) {
                    try {
                        JSONObject regionJSONObject = regionsJSONArray.getJSONObject(i);
                        this._regionService.addRegion(country.getCountryId(), regionJSONObject.getString("regionCode"), regionJSONObject.getString("name"), regionJSONObject.getBoolean("active"));
                        continue;
                    }
                    catch (PortalException portalException) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)portalException, (Throwable)portalException);
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug((Object)("No regions found for country " + a2));
            }
        }
    }
}

