/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.users.admin.internal.configuration.settings;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.users.admin.configuration.UserFileUploadsConfiguration;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;

import java.util.Map;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

/**
 * @author Drew Brokke
 */
@Component(
	configurationPid = "com.liferay.users.admin.configuration.UserFileUploadsConfiguration",
	immediate = true, service = UserFileUploadsSettings.class
)
public class UserFileUploadsSettingsImpl implements UserFileUploadsSettings {

	@Override
	public int getImageMaxHeight() {
		return _userFileUploadsConfiguration.imageMaxHeight();
	}

	@Override
	public long getImageMaxSize() {
		return _userFileUploadsConfiguration.imageMaxSize();
	}

	@Override
	public int getImageMaxWidth() {
		return _userFileUploadsConfiguration.imageMaxWidth();
	}

	@Override
	public boolean isImageCheckToken() {
		return _userFileUploadsConfiguration.imageCheckToken();
	}

	@Override
	public boolean isImageDefaultUseInitials() {
		return _userFileUploadsConfiguration.imageDefaultUseInitials();
	}

	@Activate
	@Modified
	protected void activate(Map<String, Object> properties) {
		_userFileUploadsConfiguration = ConfigurableUtil.createConfigurable(
			UserFileUploadsConfiguration.class, properties);
	}

	private UserFileUploadsConfiguration _userFileUploadsConfiguration;

}