/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.xml.Element;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class AddressStagedModelDataHandler
extends BaseStagedModelDataHandler<Address> {
    public static final String[] CLASS_NAMES = new String[]{Address.class.getName()};
    private AddressLocalService _addressLocalService;
    private GroupLocalService _groupLocalService;

    public void deleteStagedModel(Address address) {
        this._addressLocalService.deleteAddress(address);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        Address address = this._addressLocalService.fetchAddressByUuidAndCompanyId(uuid, group.getCompanyId());
        if (address != null) {
            this.deleteStagedModel(address);
        }
    }

    public void doExportStagedModel(PortletDataContext portletDataContext, Address address) throws Exception {
        Element addressElement = portletDataContext.getExportDataElement((ClassedModel)address);
        portletDataContext.addClassedModel(addressElement, ExportImportPathUtil.getModelPath((StagedModel)address), (ClassedModel)address);
    }

    public List<Address> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        addresses.add(this._addressLocalService.fetchAddressByUuidAndCompanyId(uuid, companyId));
        return addresses;
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Address address) throws Exception {
        long userId = portletDataContext.getUserId(address.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)address);
        Address existingAddress = this._addressLocalService.fetchAddressByUuidAndCompanyId(address.getUuid(), portletDataContext.getCompanyId());
        Address importedAddress = null;
        if (existingAddress == null) {
            serviceContext.setUuid(address.getUuid());
            importedAddress = this._addressLocalService.addAddress(userId, address.getClassName(), address.getClassPK(), address.getStreet1(), address.getStreet2(), address.getStreet3(), address.getCity(), address.getZip(), address.getRegionId(), address.getCountryId(), address.getTypeId(), address.getMailing(), address.isPrimary(), serviceContext);
        } else {
            importedAddress = this._addressLocalService.updateAddress(existingAddress.getAddressId(), address.getStreet1(), address.getStreet2(), address.getStreet3(), address.getCity(), address.getZip(), address.getRegionId(), address.getCountryId(), address.getTypeId(), address.getMailing(), address.isPrimary());
        }
        portletDataContext.importClassedModel((ClassedModel)address, (ClassedModel)importedAddress);
    }

    @Reference(unbind="-")
    protected void setAddressLocalService(AddressLocalService addressLocalService) {
        this._addressLocalService = addressLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }
}

