/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.search;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.NoSuchContactException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.ContactImpl;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class UserIndexer
extends BaseIndexer<User> {
    public static final String CLASS_NAME = User.class.getName();
    @Reference
    protected IndexWriterHelper indexWriterHelper;
    @Reference
    protected OrganizationLocalService organizationLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(UserIndexer.class);

    public static long getUserId(Document document) {
        return GetterUtil.getLong((String)document.get("userId"));
    }

    public UserIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "companyId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "uid", "userId"});
        this.setPermissionAware(true);
        this.setStagingAware(false);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        LinkedHashMap params;
        int status = GetterUtil.getInteger((Object)searchContext.getAttribute("status"), (int)0);
        if (status != -1) {
            contextBooleanFilter.addRequiredTerm("status", status);
        }
        if ((params = (LinkedHashMap)searchContext.getAttribute("params")) == null) {
            return;
        }
        for (Map.Entry entry : params.entrySet()) {
            Object[] values;
            Class<?> clazz;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null || (clazz = value.getClass()).isArray() && (values = (Object[])value).length == 0) continue;
            this.addContextQueryParams(contextBooleanFilter, searchContext, key, value);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String expandoAttributes;
        this.addSearchTerm(searchQuery, searchContext, "city", false);
        this.addSearchTerm(searchQuery, searchContext, "country", false);
        this.addSearchTerm(searchQuery, searchContext, "emailAddress", false);
        this.addSearchTerm(searchQuery, searchContext, "firstName", false);
        this.addSearchTerm(searchQuery, searchContext, "fullName", false);
        this.addSearchTerm(searchQuery, searchContext, "lastName", false);
        this.addSearchTerm(searchQuery, searchContext, "middleName", false);
        this.addSearchTerm(searchQuery, searchContext, "region", false);
        this.addSearchTerm(searchQuery, searchContext, "screenName", false);
        this.addSearchTerm(searchQuery, searchContext, "street", false);
        this.addSearchTerm(searchQuery, searchContext, "zip", false);
        LinkedHashMap params = (LinkedHashMap)searchContext.getAttribute("params");
        if (params != null && Validator.isNotNull((String)(expandoAttributes = (String)params.get("expandoAttributes")))) {
            this.addSearchExpando(searchQuery, searchContext, expandoAttributes);
        }
    }

    protected void addContextQueryParams(BooleanFilter contextFilter, SearchContext searchContext, String key, Object value) throws Exception {
        if (key.equals("usersGroups")) {
            if (value instanceof Long[]) {
                Object[] values = (Long[])value;
                if (ArrayUtil.isEmpty((Object[])values)) {
                    return;
                }
                TermsFilter userGroupsTermsFilter = new TermsFilter("groupIds");
                userGroupsTermsFilter.addValues(ArrayUtil.toStringArray((Object[])values));
                contextFilter.add((Filter)userGroupsTermsFilter, BooleanClauseOccur.MUST);
            } else {
                contextFilter.addRequiredTerm("groupIds", String.valueOf(value));
            }
        } else if (key.equals("usersOrgs")) {
            if (value instanceof Long[]) {
                Object[] values = (Long[])value;
                if (ArrayUtil.isEmpty((Object[])values)) {
                    return;
                }
                TermsFilter organizationsTermsFilter = new TermsFilter("organizationIds");
                TermsFilter ancestorOrgsTermsFilter = new TermsFilter("ancestorOrganizationIds");
                String[] organizationIdsStrings = ArrayUtil.toStringArray((Object[])values);
                ancestorOrgsTermsFilter.addValues(organizationIdsStrings);
                organizationsTermsFilter.addValues(organizationIdsStrings);
                BooleanFilter userOrgsBooleanFilter = new BooleanFilter();
                userOrgsBooleanFilter.add((Filter)ancestorOrgsTermsFilter);
                userOrgsBooleanFilter.add((Filter)organizationsTermsFilter);
                contextFilter.add((Filter)userOrgsBooleanFilter, BooleanClauseOccur.MUST);
            } else {
                contextFilter.addRequiredTerm("organizationIds", String.valueOf(value));
            }
        } else if (key.equals("usersOrgsCount")) {
            contextFilter.addRequiredTerm("organizationCount", String.valueOf(value));
        } else if (key.equals("usersRoles")) {
            contextFilter.addRequiredTerm("roleIds", String.valueOf(value));
        } else if (key.equals("usersTeams")) {
            contextFilter.addRequiredTerm("teamIds", String.valueOf(value));
        } else if (key.equals("usersUserGroups")) {
            contextFilter.addRequiredTerm("userGroupIds", String.valueOf(value));
        }
    }

    protected void doDelete(User user) throws Exception {
        this.deleteDocument(user.getCompanyId(), user.getUserId());
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Contact.class);
        ContactImpl contact = new ContactImpl();
        contact.setContactId(user.getContactId());
        contact.setCompanyId(user.getCompanyId());
        indexer.delete((Object)contact);
    }

    protected Document doGetDocument(User user) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)user);
        long[] organizationIds = user.getOrganizationIds();
        document.addKeyword("companyId", user.getCompanyId());
        document.addKeyword("groupId", user.getGroupIds());
        document.addDate("modified", user.getModifiedDate());
        document.addKeyword("scopeGroupId", user.getGroupIds());
        document.addKeyword("status", user.getStatus());
        document.addKeyword("userId", user.getUserId());
        document.addKeyword("userName", user.getFullName());
        document.addKeyword("ancestorOrganizationIds", this.getAncestorOrganizationIds(user.getOrganizationIds()));
        document.addText("emailAddress", user.getEmailAddress());
        document.addText("firstName", user.getFirstName());
        document.addText("fullName", user.getFullName());
        document.addKeyword("groupIds", user.getGroupIds());
        document.addText("jobTitle", user.getJobTitle());
        document.addText("lastName", user.getLastName());
        document.addText("middleName", user.getMiddleName());
        document.addKeyword("organizationIds", organizationIds);
        document.addKeyword("organizationCount", String.valueOf(organizationIds.length));
        document.addKeyword("roleIds", user.getRoleIds());
        document.addText("screenName", user.getScreenName());
        document.addKeyword("teamIds", user.getTeamIds());
        document.addKeyword("userGroupIds", user.getUserGroupIds());
        this.populateAddresses(document, user.getAddresses(), 0L, 0L);
        return document;
    }

    protected String doGetSortField(String orderByCol) {
        if (orderByCol.equals("email-address")) {
            return "emailAddress";
        }
        if (orderByCol.equals("first-name")) {
            return "firstName";
        }
        if (orderByCol.equals("job-title")) {
            return "jobTitle";
        }
        if (orderByCol.equals("last-name")) {
            return "lastName";
        }
        if (orderByCol.equals("screen-name")) {
            return "screenName";
        }
        return orderByCol;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String firstName = document.get("firstName");
        String middleName = document.get("middleName");
        String lastName = document.get("lastName");
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        String title = fullNameGenerator.getFullName(firstName, middleName, lastName);
        String content = null;
        return new Summary(title, content);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        User user = this.userLocalService.getUserById(classPK);
        this.doReindex(user);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexUsers(companyId);
    }

    protected void doReindex(User user) throws Exception {
        block3: {
            if (user.isDefaultUser()) {
                return;
            }
            Document document = this.getDocument(user);
            this.indexWriterHelper.updateDocument(this.getSearchEngineId(), user.getCompanyId(), document, this.isCommitImmediately());
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(Contact.class);
            try {
                indexer.reindex((Object)user.getContact());
            }
            catch (NoSuchContactException nsce) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)nsce, (Throwable)nsce);
            }
        }
    }

    protected long[] getAncestorOrganizationIds(long[] organizationIds) throws Exception {
        HashSet<Long> ancestorOrganizationIds = new HashSet<Long>();
        for (long organizationId : organizationIds) {
            Organization organization = this.organizationLocalService.getOrganization(organizationId);
            for (long ancestorOrganizationId : organization.getAncestorOrganizationIds()) {
                ancestorOrganizationIds.add(ancestorOrganizationId);
            }
        }
        return ArrayUtil.toLongArray(ancestorOrganizationIds);
    }

    protected void reindexUsers(long companyId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.userLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setIndexWriterHelper(this.indexWriterHelper);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<User>(){

            public void performAction(User user) {
                block3: {
                    if (!user.isDefaultUser()) {
                        try {
                            Document document = UserIndexer.this.getDocument(user);
                            indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                        }
                        catch (PortalException pe) {
                            if (!_log.isWarnEnabled()) break block3;
                            _log.warn((Object)("Unable to index user " + user.getUserId()), (Throwable)pe);
                        }
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

