/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class EmailAddressStagedModelDataHandler
extends BaseStagedModelDataHandler<EmailAddress> {
    public static final String[] CLASS_NAMES = new String[]{EmailAddress.class.getName()};
    private EmailAddressLocalService _emailAddressLocalService;
    private GroupLocalService _groupLocalService;

    public void deleteStagedModel(EmailAddress emailAddress) {
        this._emailAddressLocalService.deleteEmailAddress(emailAddress);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        EmailAddress emailAddress = this._emailAddressLocalService.fetchEmailAddressByUuidAndCompanyId(uuid, group.getCompanyId());
        this.deleteStagedModel(emailAddress);
    }

    public List<EmailAddress> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new EmailAddress[]{this._emailAddressLocalService.fetchEmailAddressByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, EmailAddress emailAddress) throws Exception {
        Element emailAddressElement = portletDataContext.getExportDataElement((ClassedModel)emailAddress);
        portletDataContext.addClassedModel(emailAddressElement, ExportImportPathUtil.getModelPath((StagedModel)emailAddress), (ClassedModel)emailAddress);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, EmailAddress emailAddress) throws Exception {
        long userId = portletDataContext.getUserId(emailAddress.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)emailAddress);
        EmailAddress existingEmailAddress = this._emailAddressLocalService.fetchEmailAddressByUuidAndCompanyId(emailAddress.getUuid(), portletDataContext.getCompanyId());
        EmailAddress importedEmailAddress = null;
        if (existingEmailAddress == null) {
            serviceContext.setUuid(emailAddress.getUuid());
            importedEmailAddress = this._emailAddressLocalService.addEmailAddress(userId, emailAddress.getClassName(), emailAddress.getClassPK(), emailAddress.getAddress(), emailAddress.getTypeId(), emailAddress.isPrimary(), serviceContext);
        } else {
            importedEmailAddress = this._emailAddressLocalService.updateEmailAddress(existingEmailAddress.getEmailAddressId(), emailAddress.getAddress(), emailAddress.getTypeId(), emailAddress.isPrimary());
        }
        portletDataContext.importClassedModel((ClassedModel)emailAddress, (ClassedModel)importedEmailAddress);
    }

    @Reference(unbind="-")
    protected void setEmailAddressLocalService(EmailAddressLocalService emailAddressLocalService) {
        this._emailAddressLocalService = emailAddressLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }
}

