/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.users.admin.internal.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class PhoneStagedModelDataHandler
extends BaseStagedModelDataHandler<Phone> {
    public static final String[] CLASS_NAMES = new String[]{Phone.class.getName()};
    private GroupLocalService _groupLocalService;
    private PhoneLocalService _phoneLocalService;

    public void deleteStagedModel(Phone phone) {
        this._phoneLocalService.deletePhone(phone);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        Phone phone = this._phoneLocalService.fetchPhoneByUuidAndCompanyId(uuid, group.getCompanyId());
        if (phone != null) {
            this.deleteStagedModel(phone);
        }
    }

    public List<Phone> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new Phone[]{this._phoneLocalService.fetchPhoneByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Phone phone) throws Exception {
        Element phoneElement = portletDataContext.getExportDataElement((ClassedModel)phone);
        portletDataContext.addClassedModel(phoneElement, ExportImportPathUtil.getModelPath((StagedModel)phone), (ClassedModel)phone);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Phone phone) throws Exception {
        long userId = portletDataContext.getUserId(phone.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)phone);
        Phone existingPhone = this._phoneLocalService.fetchPhoneByUuidAndCompanyId(phone.getUuid(), portletDataContext.getCompanyId());
        Phone importedPhone = null;
        if (existingPhone == null) {
            serviceContext.setUuid(phone.getUuid());
            importedPhone = this._phoneLocalService.addPhone(userId, phone.getClassName(), phone.getClassPK(), phone.getNumber(), phone.getExtension(), phone.getTypeId(), phone.isPrimary(), serviceContext);
        } else {
            importedPhone = this._phoneLocalService.updatePhone(existingPhone.getPhoneId(), phone.getNumber(), phone.getExtension(), phone.getTypeId(), phone.isPrimary());
        }
        portletDataContext.importClassedModel((ClassedModel)phone, (ClassedModel)importedPhone);
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setPhoneLocalService(PhoneLocalService phoneLocalService) {
        this._phoneLocalService = phoneLocalService;
    }
}

