/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeprecatedUsageCheck
extends BaseCheck {
    private static final String _ALLOWED_FULLY_QUALIFIED_CLASS_NAMES_KEY = "allowedFullyQualifiedClassNames";
    private static final FileSystem _FILE_SYSTEM = FileSystems.getDefault();
    private static final String _MSG_DEPRECATED_CONSTRUCTOR_CALL = "constructor.call.deprecated";
    private static final String _MSG_DEPRECATED_FIELD_CALL = "field.call.deprecated";
    private static final String _MSG_DEPRECATED_METHOD_CALL = "method.call.deprecated";
    private static final String _MSG_DEPRECATED_TYPE_CALL = "type.call.deprecated";
    private static final PathMatcher _PATH_MATCHER = _FILE_SYSTEM.getPathMatcher("glob:**/bnd.bnd");
    private static final PathMatcher[] _PATH_MATCHERS = new PathMatcher[]{_FILE_SYSTEM.getPathMatcher("glob:**/.git/**"), _FILE_SYSTEM.getPathMatcher("glob:**/.gradle/**"), _FILE_SYSTEM.getPathMatcher("glob:**/.idea/**"), _FILE_SYSTEM.getPathMatcher("glob:**/.m2/**"), _FILE_SYSTEM.getPathMatcher("glob:**/.settings/**"), _FILE_SYSTEM.getPathMatcher("glob:**/bin/**"), _FILE_SYSTEM.getPathMatcher("glob:**/build/**"), _FILE_SYSTEM.getPathMatcher("glob:**/classes/**"), _FILE_SYSTEM.getPathMatcher("glob:**/sql/**"), _FILE_SYSTEM.getPathMatcher("glob:**/src/**"), _FILE_SYSTEM.getPathMatcher("glob:**/test-classes/**"), _FILE_SYSTEM.getPathMatcher("glob:**/test-coverage/**"), _FILE_SYSTEM.getPathMatcher("glob:**/test-results/**"), _FILE_SYSTEM.getPathMatcher("glob:**/tmp/**")};
    private static final String _TYPE_UNKNOWN = "unknown";
    private static final Pattern _fieldNamePattern = Pattern.compile("((.*\\.)?([A-Z]\\w+))\\.(\\w+)");
    private Map<String, String> _bundleSymbolicNamesMap;
    private final Map<String, ClassInfo> _classInfoMap = new HashMap<String, ClassInfo>();
    private String _rootDirName;

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        if (AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        String absolutePath = this.getAbsolutePath();
        int x = absolutePath.lastIndexOf("/");
        String directoryPath = absolutePath.substring(0, x + 1);
        List<String> importNames = this.getImportNames(detailAST);
        String packageName = this._getPackageName(detailAST);
        this._checkDeprecatedConstructorsUsage(detailAST, packageName, importNames, directoryPath);
        this._checkDeprecatedFieldsUsage(detailAST, packageName, importNames, directoryPath);
        this._checkDeprecatedTypesUsage(detailAST, packageName, importNames, directoryPath);
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        String className = nameDetailAST.getText();
        this._checkDeprecatedMethodsUsage(detailAST, className, packageName, importNames, directoryPath);
    }

    private ClassInfo _addExtendedClassInfo(ClassInfo classInfo, ClassInfo extendedClassInfo, boolean forceDeprecated) {
        for (JavaTerm javaConstructor : extendedClassInfo.getJavaConstructors(true)) {
            classInfo.addJavaTerm(javaConstructor, true);
        }
        for (JavaTerm javaConstructor : extendedClassInfo.getJavaConstructors(false)) {
            if (forceDeprecated) {
                classInfo.addJavaTerm(javaConstructor, true);
                continue;
            }
            classInfo.addJavaTerm(javaConstructor, false);
        }
        for (JavaTerm javaMethod : extendedClassInfo.getJavaMethods(true)) {
            classInfo.addJavaTerm(javaMethod, true);
        }
        for (JavaTerm javaMethod : extendedClassInfo.getJavaMethods(false)) {
            if (forceDeprecated) {
                classInfo.addJavaTerm(javaMethod, true);
                continue;
            }
            classInfo.addJavaTerm(javaMethod, false);
        }
        for (String fieldName : extendedClassInfo.getFieldNames(true)) {
            classInfo.addFieldName(fieldName, true);
        }
        for (String fieldName : extendedClassInfo.getFieldNames(false)) {
            if (forceDeprecated) {
                classInfo.addFieldName(fieldName, true);
                continue;
            }
            classInfo.addFieldName(fieldName, false);
        }
        if (extendedClassInfo.isInheritsThirdParty()) {
            classInfo.setInheritsThirdParty(true);
        }
        return classInfo;
    }

    private void _checkDeprecatedConstructorsUsage(DetailAST detailAST, String packageName, List<String> importNames, String directoryPath) {
        List<String> allowedFullyQualifiedClassNames = this.getAttributeValues(_ALLOWED_FULLY_QUALIFIED_CLASS_NAMES_KEY);
        List<DetailAST> literalNewDetailASTList = this.getAllChildTokens(detailAST, true, 136);
        for (DetailAST literalNewDetailAST : literalNewDetailASTList) {
            ClassInfo classInfo;
            DetailAST lparenDetailAST;
            if (this._hasDeprecatedParent(literalNewDetailAST) || this._hasSuppressDeprecationWarningsAnnotation(literalNewDetailAST) || (lparenDetailAST = literalNewDetailAST.findFirstToken(76)) == null) continue;
            String constructorName = this._getConstructorName(literalNewDetailAST);
            DetailAST firstChildDetailAST = literalNewDetailAST.getFirstChild();
            String fullyQualifiedClassName = null;
            if (firstChildDetailAST.getType() == 59) {
                FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
                fullyQualifiedClassName = fullIdent.getText();
            } else {
                fullyQualifiedClassName = this._getFullyQualifiedClassName(constructorName, packageName, importNames);
            }
            if (fullyQualifiedClassName == null || !fullyQualifiedClassName.startsWith("com.liferay.") || allowedFullyQualifiedClassNames.contains(fullyQualifiedClassName) || (classInfo = this._getClassInfo(fullyQualifiedClassName, packageName, directoryPath)) == null) continue;
            if (classInfo.isDeprecatedClass()) {
                this.log(literalNewDetailAST, _MSG_DEPRECATED_TYPE_CALL, new Object[]{fullyQualifiedClassName});
                continue;
            }
            List<String> parameterTypeNames = this._getParameterTypeNames(literalNewDetailAST);
            if (classInfo.isInheritsThirdParty() && parameterTypeNames.contains(_TYPE_UNKNOWN) || !this._containsMatch(constructorName, parameterTypeNames, classInfo.getJavaConstructors(true)) || this._containsMatch(constructorName, parameterTypeNames, classInfo.getJavaConstructors(false))) continue;
            this.log(literalNewDetailAST, _MSG_DEPRECATED_CONSTRUCTOR_CALL, new Object[]{constructorName});
        }
    }

    private void _checkDeprecatedFieldsUsage(DetailAST detailAST, String packageName, List<String> importNames, String directoryPath) {
        List<String> allowedFullyQualifiedClassNames = this.getAttributeValues(_ALLOWED_FULLY_QUALIFIED_CLASS_NAMES_KEY);
        List<DetailAST> dotDetailASTList = this.getAllChildTokens(detailAST, true, 59);
        for (DetailAST dotDetailAST : dotDetailASTList) {
            String fieldName;
            List<String> deprecatedFieldNames;
            ClassInfo classInfo;
            FullIdent fullIdent;
            Matcher matcher;
            DetailAST parentDetailAST;
            if (this._hasDeprecatedParent(dotDetailAST) || this._hasSuppressDeprecationWarningsAnnotation(dotDetailAST) || (parentDetailAST = dotDetailAST.getParent()).getType() == 59 || parentDetailAST.getType() == 136 || parentDetailAST.getType() == 27 || !(matcher = _fieldNamePattern.matcher((fullIdent = FullIdent.createFullIdent((DetailAST)dotDetailAST)).getText())).find()) continue;
            String fullyQualifiedClassName = null;
            fullyQualifiedClassName = matcher.group(2) != null ? matcher.group(1) : this._getFullyQualifiedClassName(matcher.group(3), packageName, importNames);
            if (fullyQualifiedClassName == null || !fullyQualifiedClassName.startsWith("com.liferay.") || allowedFullyQualifiedClassNames.contains(fullyQualifiedClassName) || (classInfo = this._getClassInfo(fullyQualifiedClassName, packageName, directoryPath)) == null || !(deprecatedFieldNames = classInfo.getFieldNames(true)).contains(fieldName = matcher.group(4))) continue;
            if (classInfo.isDeprecatedClass()) {
                this.log(dotDetailAST, _MSG_DEPRECATED_TYPE_CALL, new Object[]{fullyQualifiedClassName});
                continue;
            }
            this.log(dotDetailAST, _MSG_DEPRECATED_FIELD_CALL, new Object[]{fieldName});
        }
    }

    private void _checkDeprecatedMethodsUsage(DetailAST detailAST, String className, String packageName, List<String> importNames, String directoryPath) {
        List<String> allowedFullyQualifiedClassNames = this.getAttributeValues(_ALLOWED_FULLY_QUALIFIED_CLASS_NAMES_KEY);
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            ClassInfo classInfo;
            String fullyQualifiedClassName;
            if (this._hasDeprecatedParent(methodCallDetailAST) || this._hasSuppressDeprecationWarningsAnnotation(methodCallDetailAST) || (fullyQualifiedClassName = this._getFullyQualifiedClassName(methodCallDetailAST, className, packageName, importNames)) == null || !fullyQualifiedClassName.startsWith("com.liferay.") || allowedFullyQualifiedClassNames.contains(fullyQualifiedClassName) || (classInfo = this._getClassInfo(fullyQualifiedClassName, packageName, directoryPath)) == null) continue;
            String methodName = this.getMethodName(methodCallDetailAST);
            if (classInfo.isDeprecatedClass()) {
                this.log(methodCallDetailAST, _MSG_DEPRECATED_TYPE_CALL, new Object[]{fullyQualifiedClassName});
                continue;
            }
            List<String> parameterTypeNames = this._getParameterTypeNames(methodCallDetailAST);
            if (classInfo.isInheritsThirdParty() && parameterTypeNames.contains(_TYPE_UNKNOWN) || !this._containsMatch(methodName, parameterTypeNames, classInfo.getJavaMethods(true)) || this._containsMatch(methodName, parameterTypeNames, classInfo.getJavaMethods(false))) continue;
            this.log(methodCallDetailAST, _MSG_DEPRECATED_METHOD_CALL, new Object[]{methodName});
        }
    }

    private void _checkDeprecatedTypesUsage(DetailAST detailAST, String packageName, List<String> importNames, String directoryPath) {
        List<DetailAST> detailASTList = this.getAllChildTokens(detailAST, true, 18, 19, 13, 164);
        for (DetailAST curDetailAST : detailASTList) {
            this._checkDeprecatedTypeUsage(curDetailAST, packageName, importNames, directoryPath);
        }
        detailASTList = this.getAllChildTokens(detailAST, true, 69, 78);
        for (DetailAST curDetailAST : detailASTList) {
            DetailAST previousSiblingDetailAST;
            DetailAST parentDetailAST = curDetailAST.getParent();
            if (parentDetailAST.getType() != 59 || (previousSiblingDetailAST = curDetailAST.getPreviousSibling()) == null) continue;
            this._checkDeprecatedTypeUsage(parentDetailAST, packageName, importNames, directoryPath);
        }
    }

    private void _checkDeprecatedTypeUsage(DetailAST detailAST, String packageName, List<String> importNames, String directoryPath) {
        if (this._hasDeprecatedParent(detailAST) || this._hasSuppressDeprecationWarningsAnnotation(detailAST)) {
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST == null) {
            return;
        }
        String className = null;
        String fullyQualifiedClassName = null;
        if (firstChildDetailAST.getType() == 58) {
            className = firstChildDetailAST.getText();
            fullyQualifiedClassName = this._getFullyQualifiedClassName(className, packageName, importNames);
        } else if (firstChildDetailAST.getType() == 59) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            fullyQualifiedClassName = className = fullIdent.getText();
        }
        List<String> allowedFullyQualifiedClassNames = this.getAttributeValues(_ALLOWED_FULLY_QUALIFIED_CLASS_NAMES_KEY);
        if (fullyQualifiedClassName == null || !fullyQualifiedClassName.startsWith("com.liferay.") || allowedFullyQualifiedClassNames.contains(fullyQualifiedClassName)) {
            return;
        }
        ClassInfo classInfo = this._getClassInfo(fullyQualifiedClassName, packageName, directoryPath);
        if (classInfo != null && classInfo.isDeprecatedClass()) {
            this.log(detailAST, _MSG_DEPRECATED_TYPE_CALL, new Object[]{className});
        }
    }

    private boolean _containsMatch(String name, List<String> parameterTypeNames, List<JavaTerm> javaTerms) {
        block0: for (JavaTerm javaTerm : javaTerms) {
            List<JavaParameter> parameters;
            if (!name.equals(javaTerm.getName()) || (parameters = this._getParameters(javaTerm)).size() != parameterTypeNames.size()) continue;
            for (int i = 0; i < parameterTypeNames.size(); ++i) {
                String parameterTypeName2;
                JavaParameter parameter = parameters.get(i);
                String parameterTypeName1 = parameter.getParameterType();
                int pos = parameterTypeName1.indexOf("<");
                if (pos != -1) {
                    parameterTypeName1 = parameterTypeName1.substring(0, pos);
                }
                if ((pos = parameterTypeName1.lastIndexOf(".")) != -1) {
                    parameterTypeName1 = parameterTypeName1.substring(pos + 1);
                }
                if (!parameterTypeName1.equals(parameterTypeName2 = parameterTypeNames.get(i)) && !parameterTypeName2.equals(_TYPE_UNKNOWN)) continue block0;
            }
            return true;
        }
        return false;
    }

    private synchronized Map<String, String> _getBundleSymbolicNamesMap() throws IOException {
        if (this._bundleSymbolicNamesMap != null) {
            return this._bundleSymbolicNamesMap;
        }
        this._bundleSymbolicNamesMap = new HashMap<String, String>();
        String rootDirName = this._getRootDirName();
        if (Validator.isNull(rootDirName)) {
            return this._bundleSymbolicNamesMap;
        }
        File modulesDir = new File(rootDirName + "/modules");
        final ArrayList files = new ArrayList();
        Files.walkFileTree(modulesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                for (PathMatcher pathMatcher : _PATH_MATCHERS) {
                    if (!pathMatcher.matches(dirPath)) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) {
                if (_PATH_MATCHER.matches(filePath)) {
                    files.add(filePath.toFile());
                }
                return FileVisitResult.CONTINUE;
            }
        });
        for (File file : files) {
            String content = FileUtil.read(file);
            String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
            if (bundleSymbolicName == null || !bundleSymbolicName.startsWith("com.liferay")) continue;
            this._bundleSymbolicNamesMap.put(bundleSymbolicName, SourceUtil.getAbsolutePath(file.getParentFile()));
        }
        return this._bundleSymbolicNamesMap;
    }

    private ClassInfo _getClassInfo(File file) {
        ClassInfo classInfo = new ClassInfo();
        try {
            String content = FileUtil.read(file);
            JavaClass javaClass = JavaClassParser.parseJavaClass(SourceUtil.getAbsolutePath(file), content);
            boolean deprecatedClass = javaClass.hasAnnotation("Deprecated");
            classInfo.setDeprecatedClass(deprecatedClass);
            for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
                if (deprecatedClass || javaTerm.hasAnnotation("Deprecated")) {
                    classInfo.addJavaTerm(javaTerm, true);
                    continue;
                }
                classInfo.addJavaTerm(javaTerm, false);
            }
            for (String fullyQualifiedName : javaClass.getExtendedClassNames(true)) {
                ClassInfo extendedClassInfo = null;
                if (!fullyQualifiedName.startsWith(javaClass.getPackageName())) {
                    extendedClassInfo = this._getClassInfo(fullyQualifiedName);
                } else {
                    String absolutePath = SourceUtil.getAbsolutePath(file);
                    int x = absolutePath.lastIndexOf("/");
                    String directoryPath = absolutePath.substring(0, x + 1);
                    extendedClassInfo = this._getClassInfo(fullyQualifiedName, javaClass.getPackageName(), directoryPath);
                }
                classInfo = this._addExtendedClassInfo(classInfo, extendedClassInfo, deprecatedClass);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return classInfo;
    }

    private ClassInfo _getClassInfo(String fullyQualifiedName) {
        return this._getClassInfo(fullyQualifiedName, null, null);
    }

    private ClassInfo _getClassInfo(String fullyQualifiedName, String packageName, String directoryPath) {
        String fileName;
        ClassInfo classInfo = this._classInfoMap.get(fullyQualifiedName);
        if (classInfo != null) {
            return classInfo;
        }
        classInfo = new ClassInfo();
        File file = null;
        if (packageName != null && fullyQualifiedName.startsWith(packageName) && !(file = new File(fileName = StringBundler.concat(directoryPath, StringUtil.replace(fullyQualifiedName.substring(packageName.length() + 1), '.', '/'), ".java"))).exists()) {
            file = null;
        }
        if (file == null) {
            file = this._getFile(fullyQualifiedName);
        }
        if (file != null) {
            classInfo = this._getClassInfo(file);
        } else {
            classInfo.setInheritsThirdParty(true);
        }
        this._classInfoMap.put(fullyQualifiedName, classInfo);
        return classInfo;
    }

    private String _getConstructorName(DetailAST literalNewDetailAST) {
        DetailAST identDetailAST = literalNewDetailAST.findFirstToken(58);
        if (identDetailAST != null) {
            return identDetailAST.getText();
        }
        DetailAST dotDetailAST = literalNewDetailAST.findFirstToken(59);
        if (dotDetailAST == null) {
            return null;
        }
        identDetailAST = dotDetailAST.findFirstToken(58);
        if (identDetailAST != null) {
            return identDetailAST.getText();
        }
        return null;
    }

    private File _getFile(String fullyQualifiedName) {
        File file;
        if (fullyQualifiedName.contains(".kernel.") && (file = this._getFile(fullyQualifiedName, "portal-kernel/src/", "portal-test/src/", "portal-impl/test/integration/", "portal-impl/test/unit/")) != null) {
            return file;
        }
        if ((fullyQualifiedName.startsWith("com.liferay.portal.") || fullyQualifiedName.startsWith("com.liferay.portlet.")) && (file = this._getFile(fullyQualifiedName, "portal-impl/src/", "portal-test/src/", "portal-test-integration/src/", "portal-impl/test/integration/", "portal-impl/test/unit/")) != null) {
            return file;
        }
        if (fullyQualifiedName.contains(".taglib.") && (file = this._getFile(fullyQualifiedName, "util-taglib/src/")) != null) {
            return file;
        }
        try {
            file = this._getModuleFile(fullyQualifiedName, this._getBundleSymbolicNamesMap());
            if (file != null) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private File _getFile(String fullyQualifiedName, String ... dirNames) {
        String rootDirName = this._getRootDirName();
        if (Validator.isNull(rootDirName)) {
            return null;
        }
        for (String dirName : dirNames) {
            StringBundler sb = new StringBundler(5);
            sb.append(rootDirName);
            sb.append("/");
            sb.append(dirName);
            sb.append(StringUtil.replace(fullyQualifiedName, '.', '/'));
            sb.append(".java");
            File file = new File(sb.toString());
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private String _getFullyQualifiedClassName(DetailAST methodCallDetailAST, String className, String packageName, List<String> importNames) {
        DetailAST firstChildDetailAST = methodCallDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 58) {
            return packageName + "." + className;
        }
        if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 59) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            return fullIdent.getText();
        }
        if (firstChildDetailAST.getType() != 58) {
            return null;
        }
        String s = firstChildDetailAST.getText();
        if (s.matches("_?[a-z].*") && Validator.isNull(s = this.getVariableTypeName(methodCallDetailAST, s, false))) {
            return null;
        }
        return this._getFullyQualifiedClassName(s, packageName, importNames);
    }

    private String _getFullyQualifiedClassName(String className, String packageName, List<String> importNames) {
        if (className == null) {
            return null;
        }
        for (String importName : importNames) {
            if (!importName.endsWith("." + className)) continue;
            return importName;
        }
        return packageName + "." + className;
    }

    private File _getModuleFile(String fullyQualifiedName, Map<String, String> bundleSymbolicNamesMap) {
        for (Map.Entry<String, String> entry : bundleSymbolicNamesMap.entrySet()) {
            String bundleSymbolicName = entry.getKey();
            String modifiedBundleSymbolicName = bundleSymbolicName.replaceAll("\\.(api|impl|service|test)$", "");
            if (!fullyQualifiedName.startsWith(modifiedBundleSymbolicName)) continue;
            StringBundler sb = new StringBundler(4);
            sb.append(entry.getValue());
            sb.append("/src/main/java/");
            sb.append(StringUtil.replace(fullyQualifiedName, '.', '/'));
            sb.append(".java");
            File file = new File(sb.toString());
            if (file.exists()) {
                return file;
            }
            sb = new StringBundler(4);
            sb.append(entry.getValue());
            sb.append("/src/testIntegration/java/");
            sb.append(StringUtil.replace(fullyQualifiedName, '.', '/'));
            sb.append(".java");
            file = new File(sb.toString());
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    private String _getPackageName(DetailAST detailAST) {
        DetailAST siblingDetailAST = detailAST.getPreviousSibling();
        while (siblingDetailAST != null) {
            if (siblingDetailAST.getType() == 16) {
                DetailAST dotDetailAST = siblingDetailAST.findFirstToken(59);
                FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)dotDetailAST);
                return fullIdent.getText();
            }
            siblingDetailAST = siblingDetailAST.getPreviousSibling();
        }
        return null;
    }

    private List<JavaParameter> _getParameters(JavaTerm javaTerm) {
        JavaSignature signature = null;
        if (javaTerm instanceof JavaMethod) {
            JavaMethod javaMethod = (JavaMethod)javaTerm;
            signature = javaMethod.getSignature();
        } else {
            JavaConstructor javaConstructor = (JavaConstructor)javaTerm;
            signature = javaConstructor.getSignature();
        }
        return signature.getParameters();
    }

    private List<String> _getParameterTypeNames(DetailAST detailAST) {
        ArrayList<String> parameterTypeNames = new ArrayList<String>();
        DetailAST elistDetailAST = detailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        for (DetailAST exprDetailAST : exprDetailASTList) {
            DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() == 58) {
                String parameterName = firstChildDetailAST.getText();
                String parameterTypeName = this.getVariableTypeName(detailAST, parameterName, false);
                if (Validator.isNotNull(parameterTypeName)) {
                    parameterTypeNames.add(parameterTypeName);
                    continue;
                }
                parameterTypeNames.add(_TYPE_UNKNOWN);
                continue;
            }
            if (firstChildDetailAST.getType() == 139) {
                parameterTypeNames.add("String");
                continue;
            }
            parameterTypeNames.add(_TYPE_UNKNOWN);
        }
        return parameterTypeNames;
    }

    private synchronized String _getRootDirName() {
        int x;
        File file;
        if (this._rootDirName != null) {
            return this._rootDirName;
        }
        String absolutePath = this.getAbsolutePath();
        do {
            if ((x = absolutePath.lastIndexOf("/")) != -1) continue;
            this._rootDirName = "";
            return this._rootDirName;
        } while (!(file = new File((absolutePath = absolutePath.substring(0, x)) + "/portal-impl")).exists());
        this._rootDirName = absolutePath;
        return this._rootDirName;
    }

    private boolean _hasDeprecatedParent(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if ((parentDetailAST.getType() == 8 || parentDetailAST.getType() == 9 || parentDetailAST.getType() == 10) && AnnotationUtil.containsAnnotation((DetailAST)parentDetailAST, (String)"Deprecated")) {
                return true;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return false;
    }

    private boolean _hasSuppressDeprecationWarningsAnnotation(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            DetailAST annotationDetailAST;
            if (parentDetailAST.findFirstToken(5) != null && (annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)parentDetailAST, (String)"SuppressWarnings")) != null) {
                List<DetailAST> literalStringDetailASTList = this.getAllChildTokens(annotationDetailAST, true, 139);
                for (DetailAST literalStringDetailAST : literalStringDetailASTList) {
                    String s = literalStringDetailAST.getText();
                    if (!s.equals("\"deprecation\"")) continue;
                    return true;
                }
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return false;
    }

    private class ClassInfo {
        private boolean _deprecatedClass;
        private final List<String> _deprecatedFieldNames = new ArrayList<String>();
        private final List<JavaTerm> _deprecatedJavaConstructors = new ArrayList<JavaTerm>();
        private final List<JavaTerm> _deprecatedJavaMethods = new ArrayList<JavaTerm>();
        private final List<String> _fieldNames = new ArrayList<String>();
        private boolean _inheritsThirdPary;
        private final List<JavaTerm> _javaConstructors = new ArrayList<JavaTerm>();
        private final List<JavaTerm> _javaMethods = new ArrayList<JavaTerm>();

        private ClassInfo() {
        }

        public void addFieldName(String fieldName, boolean deprecated) {
            if (deprecated) {
                this._deprecatedFieldNames.add(fieldName);
            } else {
                this._fieldNames.add(fieldName);
            }
        }

        public void addJavaTerm(JavaTerm javaTerm, boolean deprecated) {
            if (javaTerm instanceof JavaConstructor) {
                if (deprecated) {
                    this._deprecatedJavaConstructors.add(javaTerm);
                } else {
                    this._javaConstructors.add(javaTerm);
                }
            } else if (javaTerm instanceof JavaMethod) {
                if (deprecated) {
                    this._deprecatedJavaMethods.add(javaTerm);
                } else {
                    this._javaMethods.add(javaTerm);
                }
            } else if (javaTerm instanceof JavaVariable) {
                if (deprecated) {
                    this._deprecatedFieldNames.add(javaTerm.getName());
                } else {
                    this._fieldNames.add(javaTerm.getName());
                }
            }
        }

        public List<String> getFieldNames(boolean deprecated) {
            if (deprecated) {
                return this._deprecatedFieldNames;
            }
            return this._fieldNames;
        }

        public List<JavaTerm> getJavaConstructors(boolean deprecated) {
            if (deprecated) {
                return this._deprecatedJavaConstructors;
            }
            return this._javaConstructors;
        }

        public List<JavaTerm> getJavaMethods(boolean deprecated) {
            if (deprecated) {
                return this._deprecatedJavaMethods;
            }
            return this._javaMethods;
        }

        public boolean isDeprecatedClass() {
            return this._deprecatedClass;
        }

        public boolean isInheritsThirdParty() {
            return this._inheritsThirdPary;
        }

        public void setDeprecatedClass(boolean deprecatedClass) {
            this._deprecatedClass = deprecatedClass;
        }

        public void setInheritsThirdParty(boolean inheritsThirdPary) {
            this._inheritsThirdPary = inheritsThirdPary;
        }
    }
}

