/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStaticImportsCheck
extends BaseFileCheck {
    private static final Pattern _importConstantPattern = Pattern.compile("\nimport static ((.*)\\.[A-Z_]*);");
    private static final Pattern _importMethodPattern = Pattern.compile("\nimport static ((.*\\.(Assert|(Power)?Mockito))\\.[a-z]\\w*);");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        StringBundler sb;
        Matcher matcher = _importMethodPattern.matcher(content);
        while (matcher.find()) {
            sb = new StringBundler(5);
            sb.append("Do not import method '");
            sb.append(matcher.group(1));
            sb.append("', import class '");
            sb.append(matcher.group(2));
            sb.append("' instead");
            this.addMessage(fileName, sb.toString(), this.getLineNumber(content, matcher.end()));
        }
        matcher = _importConstantPattern.matcher(content);
        while (matcher.find()) {
            sb = new StringBundler(5);
            sb.append("Do not import constant '");
            sb.append(matcher.group(1));
            sb.append("', import class '");
            sb.append(matcher.group(2));
            sb.append("' instead or use Fully Qualified Name");
            this.addMessage(fileName, sb.toString(), this.getLineNumber(content, matcher.end()));
        }
        return content;
    }
}

